/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.syncrepl_impl;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.api.asn1.ber.grammar.Grammar;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueContainer;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueStatesEnum;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncDoneValueGrammar
extends AbstractGrammar<SyncDoneValueContainer> {
    private static final Logger LOG = LoggerFactory.getLogger(SyncDoneValueGrammar.class);
    private static final SyncDoneValueGrammar INSTANCE = new SyncDoneValueGrammar();

    private SyncDoneValueGrammar() {
        this.setName(SyncDoneValueGrammar.class.getName());
        this.transitions = new GrammarTransition[SyncDoneValueStatesEnum.LAST_SYNC_DONE_VALUE_STATE.ordinal()][256];
        this.transitions[SyncDoneValueStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition<SyncDoneValueContainer>(SyncDoneValueStatesEnum.START_STATE, SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, UniversalTag.SEQUENCE.getValue(), new GrammarAction<SyncDoneValueContainer>("Initialization"){

            @Override
            public void action(SyncDoneValueContainer container) {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition<SyncDoneValueContainer>(SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, SyncDoneValueStatesEnum.COOKIE_STATE, UniversalTag.OCTET_STRING.getValue(), new GrammarAction<SyncDoneValueContainer>("Set SyncDoneValueControl cookie"){

            @Override
            public void action(SyncDoneValueContainer container) {
                BerValue value = container.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg(I18n.MSG_08000_COOKIE, Strings.dumpBytes(cookie)));
                }
                container.getSyncDoneValue().setCookie(cookie);
                container.setGrammarEndAllowed(true);
            }
        });
        GrammarAction<SyncDoneValueContainer> refreshDeletesTagAction = new GrammarAction<SyncDoneValueContainer>("set SyncDoneValueControl refreshDeletes flag"){

            @Override
            public void action(SyncDoneValueContainer container) throws DecoderException {
                BerValue value = container.getCurrentTLV().getValue();
                try {
                    boolean refreshDeletes = BooleanDecoder.parse(value);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.msg(I18n.MSG_08001_REFRESH_DELETES, refreshDeletes));
                    }
                    container.getSyncDoneValue().setRefreshDeletes(refreshDeletes);
                    container.setGrammarEndAllowed(true);
                }
                catch (BooleanDecoderException be) {
                    String msg = I18n.err(I18n.ERR_08001_CANNOT_DECODE_REFRESH_DELETES, new Object[0]);
                    LOG.error(msg, (Throwable)be);
                    throw new DecoderException(msg, be);
                }
            }
        };
        this.transitions[SyncDoneValueStatesEnum.COOKIE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncDoneValueContainer>(SyncDoneValueStatesEnum.COOKIE_STATE, SyncDoneValueStatesEnum.REFRESH_DELETES_STATE, UniversalTag.BOOLEAN.getValue(), refreshDeletesTagAction);
        this.transitions[SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition<SyncDoneValueContainer>(SyncDoneValueStatesEnum.SYNC_DONE_VALUE_SEQUENCE_STATE, SyncDoneValueStatesEnum.REFRESH_DELETES_STATE, UniversalTag.BOOLEAN.getValue(), refreshDeletesTagAction);
    }

    public static Grammar<SyncDoneValueContainer> getInstance() {
        return INSTANCE;
    }
}

