/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.option;

import org.apache.torque.generator.configuration.SaxHelper;
import org.apache.torque.generator.configuration.option.FileOptionsConfiguration;
import org.apache.torque.generator.configuration.option.OptionsSaxHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FileOptionsSaxHandler
extends OptionsSaxHandler {
    private FileOptionsConfiguration optionsConfiguration;

    public FileOptionsSaxHandler(FileOptionsConfiguration optionsConfiguration) {
        super(optionsConfiguration);
        this.optionsConfiguration = optionsConfiguration;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String path;
        String unqualifiedName = SaxHelper.getUnqualifiedName(localName, qName);
        if ("options".equals(unqualifiedName)) {
            path = attributes.getValue("path");
            if (path == null) {
                throw new SAXException("path must not be null for file options");
            }
        } else {
            throw new SAXException("Unknown element " + unqualifiedName);
        }
        this.optionsConfiguration.setPath(path);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String unqualifiedName = SaxHelper.getUnqualifiedName(localName, qName);
        if (!"options".equals(unqualifiedName)) {
            throw new SAXException("Unknown element " + unqualifiedName);
        }
        this.finished();
    }
}

