<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Changelog
All notable changes to this project will be documented in one of the linked
files. 

This project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Given that the parser produces a typed AST, any changes to the AST will
technically be breaking and thus will result in a `0.(N+1)` version. 


- Unreleased: Check https://github.com/sqlparser-rs/sqlparser-rs/commits/main for undocumented changes.
- `0.56.0`: [changelog/0.56.0.md](changelog/0.56.0.md)
- `0.55.0`: [changelog/0.55.0.md](changelog/0.55.0.md)
- `0.54.0`: [changelog/0.54.0.md](changelog/0.54.0.md)
- `0.53.0`: [changelog/0.53.0.md](changelog/0.53.0.md)
- `0.52.0`: [changelog/0.52.0.md](changelog/0.52.0.md)
- `0.51.0` and earlier: [changelog/0.51.0-pre.md](changelog/0.51.0-pre.md)
