/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import org.codehaus.swizzle.stream.ReplaceVariablesInputStream;

public class StringTemplate {
    private final String template;

    public StringTemplate(String template) {
        this.template = template;
    }

    public String apply(Map context) {
        InputStream in = new ByteArrayInputStream(this.template.getBytes());
        in = new ReplaceVariablesInputStream(in, "{", "}", context);
        StringWriter stringWriter = new StringWriter(this.template.length() * 2);
        try {
            int i = in.read();
            while (i != -1) {
                stringWriter.write(i);
                i = in.read();
            }
            stringWriter.close();
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply the template '" + this.template + "'", e);
        }
    }
}

