/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle;

import java.util.ArrayList;

public class Grep {
    private String regex;
    private int context = 0;
    private String contextSeparator = "--";

    public Grep(String regex, int context) {
        this.regex = regex;
        this.context = context;
    }

    public String filter(String content) {
        ArrayList<String> matches = new ArrayList<String>();
        String[] lines = content.split("\n");
        int contextMatch = 0;
        boolean matched = false;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.matches(this.regex)) {
                matches.add(line);
                contextMatch = this.context;
                continue;
            }
            if (contextMatch > 0) {
                matches.add(line);
                --contextMatch;
                matched = true;
                continue;
            }
            if (this.lookAhead(i, this.context, lines)) {
                matches.add(line);
                continue;
            }
            if (matched) {
                matches.add(this.contextSeparator);
            }
            matched = false;
        }
        if (matches.size() == 0) {
            return "";
        }
        String last = (String)matches.get(matches.size() - 1);
        if (last.equals(this.contextSeparator)) {
            matches.remove(matches.size() - 1);
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < matches.size(); ++i) {
            result.append((String)matches.get(i));
            result.append('\n');
        }
        return result.toString();
    }

    private boolean lookAhead(int i, int context, String[] lines) {
        int end = Math.min(i + context + 1, lines.length);
        while (i < end) {
            String line = lines[i];
            if (line.matches(this.regex)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

