/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

public class PropertyMessageResources
extends MessageResources {
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_JSTL = 1;
    private static final int MODE_RESOURCE_BUNDLE = 2;
    protected static final Log log = LogFactory.getLog(PropertyMessageResources.class);
    protected HashMap locales = new HashMap();
    protected HashMap messages = new HashMap();
    private int mode = 0;

    public PropertyMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        log.trace("Initializing, config='" + config + "'");
    }

    public PropertyMessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super(factory, config, returnNull);
        log.trace("Initializing, config='" + config + "', returnNull=" + returnNull);
    }

    public void setMode(String mode) {
        String value;
        String string = value = mode == null ? null : mode.trim();
        if ("jstl".equalsIgnoreCase(value)) {
            this.mode = 1;
            if (log.isDebugEnabled()) {
                log.info("Operating in JSTL compatible mode [" + mode + "]");
            }
        } else if ("resource".equalsIgnoreCase(value)) {
            this.mode = 2;
            if (log.isDebugEnabled()) {
                log.info("Operating in PropertyResourceBundle compatible mode [" + mode + "]");
            }
        } else {
            this.mode = 0;
            if (log.isDebugEnabled()) {
                log.info("Operating in Default mode [" + mode + "]");
            }
        }
    }

    public String getMessage(Locale locale, String key) {
        if (log.isDebugEnabled()) {
            log.debug("getMessage(" + locale + "," + key + ")");
        }
        String localeKey = this.localeKey(locale);
        String originalKey = this.messageKey(localeKey, key);
        String message = null;
        message = this.findMessage(locale, key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.mode != 1) {
            if (this.mode == 2) {
                if (!this.defaultLocale.equals(locale)) {
                    message = this.findMessage(this.defaultLocale, key, originalKey);
                }
            } else if (!this.defaultLocale.equals(locale)) {
                localeKey = this.localeKey(this.defaultLocale);
                message = this.findMessage(localeKey, key, originalKey);
            }
        }
        if (message != null) {
            return message;
        }
        message = this.findMessage("", key, originalKey);
        if (message != null) {
            return message;
        }
        if (this.returnNull) {
            return null;
        }
        return "???" + this.messageKey(locale, key) + "???";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void loadLocale(String localeKey) {
        ClassLoader classLoader;
        if (log.isTraceEnabled()) {
            log.trace("loadLocale(" + localeKey + ")");
        }
        if (this.locales.get(localeKey) != null) {
            return;
        }
        this.locales.put(localeKey, localeKey);
        String name = this.config.replace('.', '/');
        if (localeKey.length() > 0) {
            name = name + "_" + localeKey;
        }
        name = name + ".properties";
        InputStream is = null;
        Properties props = new Properties();
        if (log.isTraceEnabled()) {
            log.trace("  Loading resource '" + name + "'");
        }
        if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if ((is = classLoader.getResourceAsStream(name)) != null) {
            try {
                props.load(is);
            }
            catch (IOException e) {
                log.error("loadLocale()", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("loadLocale()", e);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("  Loading resource completed");
            }
        } else if (log.isWarnEnabled()) {
            log.warn("  Resource " + name + " Not Found.");
        }
        if (props.size() < 1) {
            return;
        }
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            Iterator<Object> names = props.keySet().iterator();
            while (names.hasNext()) {
                String key = (String)names.next();
                if (log.isTraceEnabled()) {
                    log.trace("  Saving message key '" + this.messageKey(localeKey, key));
                }
                this.messages.put(this.messageKey(localeKey, key), props.getProperty(key));
            }
        }
    }

    private String findMessage(Locale locale, String key, String originalKey) {
        String localeKey = this.localeKey(locale);
        Object messageKey = null;
        String message = null;
        int underscore = 0;
        while ((message = this.findMessage(localeKey, key, originalKey)) == null && (underscore = localeKey.lastIndexOf("_")) >= 0) {
            localeKey = localeKey.substring(0, underscore);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findMessage(String localeKey, String key, String originalKey) {
        this.loadLocale(localeKey);
        String messageKey = this.messageKey(localeKey, key);
        boolean addIt = !messageKey.equals(originalKey);
        HashMap hashMap = this.messages;
        synchronized (hashMap) {
            String message = (String)this.messages.get(messageKey);
            if (message != null && addIt) {
                this.messages.put(originalKey, message);
            }
            return message;
        }
    }
}

