/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles.filter;

import java.io.File;
import java.io.FileFilter;

final class IsArchiveInPathFilter
implements FileFilter {
    private static final String MATCH_PATTERN = ".*\\.(jar|zip|war|ear|rar|tar.gz)";
    private final String pathNameFilter;

    IsArchiveInPathFilter(String pathNameFilter) {
        this.pathNameFilter = pathNameFilter;
    }

    @Override
    public boolean accept(File pathname) {
        String path = pathname.getAbsolutePath();
        return path.matches(this.pathNameFilter) && this.isValidArchive(path);
    }

    private boolean isValidArchive(String path) {
        return path.matches(MATCH_PATTERN);
    }
}

