/*
 * Decompiled with CFR 0.152.
 */
package org.apache.creadur.tentacles;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.creadur.tentacles.FileSystem;
import org.apache.creadur.tentacles.IOSystem;
import org.apache.creadur.tentacles.Platform;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;
import org.codehaus.swizzle.stream.StreamLexer;

public class NexusClient {
    private static final Logger log = Logger.getLogger(NexusClient.class);
    private static final String SLASH = "/";
    private static final String ONE_UP = "../";
    private static final String USER_AGENT_CONTENTS = "Mozilla/5.0 (X11; U; Linux x86_64; en-US; rv:1.9.2.13) Gecko/20101206 Ubuntu/10.10 (maverick) Firefox/3.6.13";
    private final CloseableHttpClient client;
    private final FileSystem fileSystem;
    private final IOSystem ioSystem;
    private final int retries;

    public NexusClient(Platform platform) {
        System.setProperty("http.keepAlive", "false");
        System.setProperty("http.maxConnections", "50");
        this.retries = Integer.parseInt(System.getProperty("NexusClient.retries", "5"));
        this.client = HttpClientBuilder.create().disableContentCompression().build();
        this.fileSystem = platform.getFileSystem();
        this.ioSystem = platform.getIoSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File download(URI uri, File file) throws IOException {
        if (file.exists()) {
            long length = this.getContentLength(uri);
            if (file.length() == length) {
                log.info("Exists " + uri);
                return file;
            }
            log.info("Incomplete " + uri);
        }
        log.info("Download " + uri);
        CloseableHttpResponse response = this.get(uri);
        InputStream content = null;
        try {
            content = response.getEntity().getContent();
            this.fileSystem.mkparent(file);
            this.ioSystem.copy(content, file);
        }
        finally {
            if (content != null) {
                content.close();
            }
            response.close();
        }
        return file;
    }

    private Long getContentLength(URI uri) throws IOException {
        CloseableHttpResponse head = this.head(uri);
        Header[] headers = head.getHeaders("Content-Length");
        if (headers != null && headers.length >= 1) {
            return Long.valueOf(headers[0].getValue());
        }
        head.close();
        return -1L;
    }

    private CloseableHttpResponse get(URI uri) throws IOException {
        return this.get(new HttpGet(uri), this.retries);
    }

    private CloseableHttpResponse head(URI uri) throws IOException {
        return this.get(new HttpHead(uri), this.retries);
    }

    private CloseableHttpResponse get(HttpUriRequest request, int tries) throws IOException {
        try {
            request.setHeader("User-Agent", USER_AGENT_CONTENTS);
            return this.client.execute(request);
        }
        catch (IOException e) {
            if (tries > 0) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ie) {
                    Thread.interrupted();
                    throw new IOException("Interrupted", ie);
                }
                return this.get(request, tries--);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<URI> crawl(URI index) throws IOException {
        log.info("Crawl " + index);
        LinkedHashSet<URI> resources = new LinkedHashSet<URI>();
        CloseableHttpResponse response = this.get(index);
        InputStream content = response.getEntity().getContent();
        StreamLexer lexer = new StreamLexer(content);
        LinkedHashSet<URI> crawl = new LinkedHashSet<URI>();
        while (lexer.readAndMark("<a ", "/a>")) {
            try {
                String link = lexer.peek("href=\"", "\"");
                String name = lexer.peek(">", "<");
                URI uri = index.resolve(link);
                if (name.equals(ONE_UP) || link.equals(ONE_UP)) continue;
                if (name.endsWith(SLASH)) {
                    crawl.add(uri);
                    continue;
                }
                resources.add(uri);
            }
            finally {
                lexer.unmark();
            }
        }
        content.close();
        response.close();
        for (URI uri : crawl) {
            resources.addAll(this.crawl(uri));
        }
        return resources;
    }
}

