/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.ColumnNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.TableNode;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class TableNodeBuilder
implements NodeBuilder {
    private final String tableName;
    private final DbEntity dbEntity;
    private String alias;

    TableNodeBuilder(String tableName) {
        this.tableName = Objects.requireNonNull(tableName);
        this.dbEntity = null;
    }

    TableNodeBuilder(DbEntity dbEntity) {
        this.dbEntity = Objects.requireNonNull(dbEntity);
        this.tableName = dbEntity.getName();
    }

    public TableNodeBuilder as(String alias) {
        this.alias = alias;
        return this;
    }

    public ColumnNodeBuilder column(String column) {
        return new ColumnNodeBuilder(this.tableName, column);
    }

    public ColumnNodeBuilder column(DbAttribute attribute) {
        return new ColumnNodeBuilder(this.tableName, attribute);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public Node build() {
        if (this.dbEntity != null) {
            return new TableNode(this.dbEntity, this.alias);
        }
        return new TableNode(this.tableName, this.alias);
    }
}

