/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.compatibility;

import java.net.URL;
import java.util.List;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.project.compatibility.DocumentProvider;
import org.apache.cayenne.project.upgrade.DefaultUpgradeService;
import org.apache.cayenne.project.upgrade.UpgradeUnit;
import org.apache.cayenne.project.upgrade.handlers.UpgradeHandler;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.util.Util;
import org.w3c.dom.Document;

public class CompatibilityUpgradeService
extends DefaultUpgradeService {
    @Inject
    DocumentProvider documentProvider;

    public CompatibilityUpgradeService(@Inject List<UpgradeHandler> handlerList) {
        super(handlerList);
    }

    public Resource upgradeProject(Resource resource) {
        List handlerList = this.getHandlersForVersion(this.loadProjectVersion(resource));
        List upgradeUnits = this.upgradeDOM(resource, handlerList);
        for (UpgradeUnit unit : upgradeUnits) {
            this.documentProvider.putDocument(unit.getResource().getURL(), unit.getDocument());
        }
        return resource;
    }

    public Resource upgradeDataMap(Resource resource) {
        List handlerList = this.getHandlersForVersion(this.loadProjectVersion(resource));
        Document document = Util.readDocument((URL)resource.getURL());
        UpgradeUnit upgradeUnit = new UpgradeUnit(resource, document);
        for (UpgradeHandler handler : handlerList) {
            handler.processDataMapDom(upgradeUnit);
        }
        this.documentProvider.putDocument(upgradeUnit.getResource().getURL(), upgradeUnit.getDocument());
        return upgradeUnit.getResource();
    }

    public void upgradeModel(Resource resource, DataChannelDescriptor descriptor) {
        List handlerList = this.getHandlersForVersion(this.loadProjectVersion(resource));
        for (UpgradeHandler handler : handlerList) {
            handler.processModel(descriptor);
        }
    }
}

