/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.cassandra.net;

import java.nio.ByteBuffer;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;

/**
 * A no-op frame encoder: legacy format doesn't support framing. Instead, the byte stream
 * contains messages, serialized back to back.
 */
@ChannelHandler.Sharable
class FrameEncoderLegacy extends FrameEncoder
{
    static final FrameEncoderLegacy instance = new FrameEncoderLegacy();

    ByteBuf encode(boolean isSelfContained, ByteBuffer buffer)
    {
        return GlobalBufferPoolAllocator.wrap(buffer);
    }
}
