/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Dapr component which interfaces with Dapr Building Blocks.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface DaprEndpointBuilderFactory {

    /**
     * Builder for endpoint consumers for the Dapr component.
     */
    public interface DaprEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedDaprEndpointConsumerBuilder advanced() {
            return (AdvancedDaprEndpointConsumerBuilder) this;
        }
        /**
         * List of keys for configuration operation.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder configKeys(List<java.lang.String> configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * List of keys for configuration operation.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder configKeys(String configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * The name of the Dapr configuration store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param configStore the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder configStore(String configStore) {
            doSetProperty("configStore", configStore);
            return this;
        }
        /**
         * The contentType for the Pub/Sub component to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param pubSubName the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder pubSubName(String pubSubName) {
            doSetProperty("pubSubName", pubSubName);
            return this;
        }
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topic the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
        /**
         * The client to consume messages by the consumer.
         * 
         * The option is a: <code>io.dapr.client.DaprPreviewClient</code> type.
         * 
         * Group: consumer
         * 
         * @param previewClient the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder previewClient(io.dapr.client.DaprPreviewClient previewClient) {
            doSetProperty("previewClient", previewClient);
            return this;
        }
        /**
         * The client to consume messages by the consumer.
         * 
         * The option will be converted to a
         * <code>io.dapr.client.DaprPreviewClient</code> type.
         * 
         * Group: consumer
         * 
         * @param previewClient the value to set
         * @return the dsl builder
         */
        default DaprEndpointConsumerBuilder previewClient(String previewClient) {
            doSetProperty("previewClient", previewClient);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Dapr component.
     */
    public interface AdvancedDaprEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default DaprEndpointConsumerBuilder basic() {
            return (DaprEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder bridgeErrorHandler(String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a: <code>org.apache.camel.spi.ExceptionHandler</code>
         * type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder exceptionHandler(org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.spi.ExceptionHandler</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder exceptionHandler(String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a: <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder exchangePattern(org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.ExchangePattern</code> type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointConsumerBuilder exchangePattern(String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Dapr component.
     */
    public interface DaprEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedDaprEndpointProducerBuilder advanced() {
            return (AdvancedDaprEndpointProducerBuilder) this;
        }

        /**
         * List of keys for configuration operation.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder configKeys(List<java.lang.String> configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * List of keys for configuration operation.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder configKeys(String configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * The name of the Dapr configuration store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param configStore the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder configStore(String configStore) {
            doSetProperty("configStore", configStore);
            return this;
        }
        /**
         * The contentType for the Pub/Sub component to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param pubSubName the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder pubSubName(String pubSubName) {
            doSetProperty("pubSubName", pubSubName);
            return this;
        }
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topic the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
        /**
         * The name of the Dapr binding to invoke.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param bindingName the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder bindingName(String bindingName) {
            doSetProperty("bindingName", bindingName);
            return this;
        }
        /**
         * The operation to perform on the binding.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param bindingOperation the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder bindingOperation(String bindingOperation) {
            doSetProperty("bindingOperation", bindingOperation);
            return this;
        }
        /**
         * Concurrency mode to use with state operations.
         * 
         * The option is a:
         * <code>io.dapr.client.domain.StateOptions.Concurrency</code> type.
         * 
         * Group: producer
         * 
         * @param concurrency the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder concurrency(io.dapr.client.domain.StateOptions.Concurrency concurrency) {
            doSetProperty("concurrency", concurrency);
            return this;
        }
        /**
         * Concurrency mode to use with state operations.
         * 
         * The option will be converted to a
         * <code>io.dapr.client.domain.StateOptions.Concurrency</code> type.
         * 
         * Group: producer
         * 
         * @param concurrency the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder concurrency(String concurrency) {
            doSetProperty("concurrency", concurrency);
            return this;
        }
        /**
         * Consistency level to use with state operations.
         * 
         * The option is a:
         * <code>io.dapr.client.domain.StateOptions.Consistency</code> type.
         * 
         * Group: producer
         * 
         * @param consistency the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder consistency(io.dapr.client.domain.StateOptions.Consistency consistency) {
            doSetProperty("consistency", consistency);
            return this;
        }
        /**
         * Consistency level to use with state operations.
         * 
         * The option will be converted to a
         * <code>io.dapr.client.domain.StateOptions.Consistency</code> type.
         * 
         * Group: producer
         * 
         * @param consistency the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder consistency(String consistency) {
            doSetProperty("consistency", consistency);
            return this;
        }
        /**
         * The eTag for optimistic concurrency during state save or delete
         * operations.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param eTag the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder eTag(String eTag) {
            doSetProperty("eTag", eTag);
            return this;
        }
        /**
         * HTTP method to use when invoking the service. Accepts verbs like GET,
         * POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no
         * headers or query params. Takes precedence over verb.
         * 
         * The option is a: <code>io.dapr.client.domain.HttpExtension</code>
         * type.
         * 
         * Group: producer
         * 
         * @param httpExtension the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder httpExtension(io.dapr.client.domain.HttpExtension httpExtension) {
            doSetProperty("httpExtension", httpExtension);
            return this;
        }
        /**
         * HTTP method to use when invoking the service. Accepts verbs like GET,
         * POST, PUT, DELETE, etc. Creates a minimal HttpExtension with no
         * headers or query params. Takes precedence over verb.
         * 
         * The option will be converted to a
         * <code>io.dapr.client.domain.HttpExtension</code> type.
         * 
         * Group: producer
         * 
         * @param httpExtension the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder httpExtension(String httpExtension) {
            doSetProperty("httpExtension", httpExtension);
            return this;
        }
        /**
         * The key used to identify the state/secret object within the specified
         * state/secret store.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param key the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder key(String key) {
            doSetProperty("key", key);
            return this;
        }
        /**
         * The name of the method or route to invoke on the target service.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param methodToInvoke the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder methodToInvoke(String methodToInvoke) {
            doSetProperty("methodToInvoke", methodToInvoke);
            return this;
        }
        /**
         * The name of the Dapr secret store to interact with, defined in
         * local-secret-store.yaml config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param secretStore the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder secretStore(String secretStore) {
            doSetProperty("secretStore", secretStore);
            return this;
        }
        /**
         * Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint,
         * or a FQDN/public URL.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param serviceToInvoke the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder serviceToInvoke(String serviceToInvoke) {
            doSetProperty("serviceToInvoke", serviceToInvoke);
            return this;
        }
        /**
         * The state operation to perform on the state store. Required for
         * DaprOperation.state operation.
         * 
         * The option is a:
         * <code>org.apache.camel.component.dapr.StateOperation</code> type.
         * 
         * Default: get
         * Group: producer
         * 
         * @param stateOperation the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder stateOperation(org.apache.camel.component.dapr.StateOperation stateOperation) {
            doSetProperty("stateOperation", stateOperation);
            return this;
        }
        /**
         * The state operation to perform on the state store. Required for
         * DaprOperation.state operation.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.dapr.StateOperation</code> type.
         * 
         * Default: get
         * Group: producer
         * 
         * @param stateOperation the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder stateOperation(String stateOperation) {
            doSetProperty("stateOperation", stateOperation);
            return this;
        }
        /**
         * The name of the Dapr state store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param stateStore the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder stateStore(String stateStore) {
            doSetProperty("stateStore", stateStore);
            return this;
        }
        /**
         * The HTTP verb to use for invoking the method.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: POST
         * Group: producer
         * 
         * @param verb the value to set
         * @return the dsl builder
         */
        default DaprEndpointProducerBuilder verb(String verb) {
            doSetProperty("verb", verb);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Dapr component.
     */
    public interface AdvancedDaprEndpointProducerBuilder extends EndpointProducerBuilder {
        default DaprEndpointProducerBuilder basic() {
            return (DaprEndpointProducerBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointProducerBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedDaprEndpointProducerBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Dapr component.
     */
    public interface DaprEndpointBuilder
            extends
                DaprEndpointConsumerBuilder,
                DaprEndpointProducerBuilder {
        default AdvancedDaprEndpointBuilder advanced() {
            return (AdvancedDaprEndpointBuilder) this;
        }

        /**
         * List of keys for configuration operation.
         * 
         * The option is a: <code>java.util.List&lt;java.lang.String&gt;</code>
         * type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder configKeys(List<java.lang.String> configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * List of keys for configuration operation.
         * 
         * The option will be converted to a
         * <code>java.util.List&lt;java.lang.String&gt;</code> type.
         * 
         * Group: common
         * 
         * @param configKeys the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder configKeys(String configKeys) {
            doSetProperty("configKeys", configKeys);
            return this;
        }
        /**
         * The name of the Dapr configuration store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param configStore the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder configStore(String configStore) {
            doSetProperty("configStore", configStore);
            return this;
        }
        /**
         * The contentType for the Pub/Sub component to use.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param contentType the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder contentType(String contentType) {
            doSetProperty("contentType", contentType);
            return this;
        }
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param pubSubName the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder pubSubName(String pubSubName) {
            doSetProperty("pubSubName", pubSubName);
            return this;
        }
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param topic the value to set
         * @return the dsl builder
         */
        default DaprEndpointBuilder topic(String topic) {
            doSetProperty("topic", topic);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Dapr component.
     */
    public interface AdvancedDaprEndpointBuilder
            extends
                AdvancedDaprEndpointConsumerBuilder,
                AdvancedDaprEndpointProducerBuilder {
        default DaprEndpointBuilder basic() {
            return (DaprEndpointBuilder) this;
        }

    }

    public interface DaprBuilders {
        /**
         * Dapr (camel-dapr)
         * Dapr component which interfaces with Dapr Building Blocks.
         * 
         * Category: cloud,saas
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-dapr
         * 
         * @return the dsl builder for the headers' name.
         */
        default DaprHeaderNameBuilder dapr() {
            return DaprHeaderNameBuilder.INSTANCE;
        }
        /**
         * Dapr (camel-dapr)
         * Dapr component which interfaces with Dapr Building Blocks.
         * 
         * Category: cloud,saas
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-dapr
         * 
         * Syntax: <code>dapr:operation</code>
         * 
         * Path parameter: operation (required)
         * The Dapr building block operation to perform with this component
         * There are 2 enums and the value can be one of: invokeService, state
         * 
         * @param path operation
         * @return the dsl builder
         */
        default DaprEndpointBuilder dapr(String path) {
            return DaprEndpointBuilderFactory.endpointBuilder("dapr", path);
        }
        /**
         * Dapr (camel-dapr)
         * Dapr component which interfaces with Dapr Building Blocks.
         * 
         * Category: cloud,saas
         * Since: 4.12
         * Maven coordinates: org.apache.camel:camel-dapr
         * 
         * Syntax: <code>dapr:operation</code>
         * 
         * Path parameter: operation (required)
         * The Dapr building block operation to perform with this component
         * There are 2 enums and the value can be one of: invokeService, state
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path operation
         * @return the dsl builder
         */
        default DaprEndpointBuilder dapr(String componentName, String path) {
            return DaprEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the Dapr component.
     */
    public static class DaprHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final DaprHeaderNameBuilder INSTANCE = new DaprHeaderNameBuilder();

        /**
         * Target service to invoke. Can be a Dapr App ID, a named HTTPEndpoint,
         * or a FQDN/public URL.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprServiceToInvoke}.
         */
        public String daprServiceToInvoke() {
            return "CamelDaprServiceToInvoke";
        }
        /**
         * The name of the method or route to invoke on the target service.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprMethodToInvoke}.
         */
        public String daprMethodToInvoke() {
            return "CamelDaprMethodToInvoke";
        }
        /**
         * The HTTP verb to use for service invocation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprVerb}.
         */
        public String daprVerb() {
            return "CamelDaprVerb";
        }
        /**
         * The query parameters for HTTP requests.
         * 
         * The option is a: {@code Map<String, List<String>>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprQueryParameters}.
         */
        public String daprQueryParameters() {
            return "CamelDaprQueryParameters";
        }
        /**
         * The headers for HTTP requests.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprHttpHeaders}.
         */
        public String daprHttpHeaders() {
            return "CamelDaprHttpHeaders";
        }
        /**
         * The HttpExtension object for service invocation. Takes precedence
         * over verb.
         * 
         * The option is a: {@code HttpExtension} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprHttpExtension}.
         */
        public String daprHttpExtension() {
            return "CamelDaprHttpExtension";
        }
        /**
         * The state operation to perform on the state store. Required for
         * DaprOperation.state operation.
         * 
         * The option is a: {@code StateOperation} type.
         * 
         * Default: get
         * Group: producer
         * 
         * @return the name of the header {@code DaprStateOperation}.
         */
        public String daprStateOperation() {
            return "CamelDaprStateOperation";
        }
        /**
         * The name of the Dapr state store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprStateStore}.
         */
        public String daprStateStore() {
            return "CamelDaprStateStore";
        }
        /**
         * The name of the Dapr secret store to interact with, defined in
         * local-secret-store.yaml config.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprSecretStore}.
         */
        public String daprSecretStore() {
            return "CamelDaprSecretStore";
        }
        /**
         * The name of the Dapr config store to interact with, defined in
         * statestore.yaml config.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprConfigStore}.
         */
        public String daprConfigStore() {
            return "CamelDaprConfigStore";
        }
        /**
         * The key used to identify the state/secret object within the specified
         * state/secret store.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprKey}.
         */
        public String daprKey() {
            return "CamelDaprKey";
        }
        /**
         * The eTag for optimistic concurrency during state save or delete
         * operations.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprETag}.
         */
        public String daprETag() {
            return "CamelDaprETag";
        }
        /**
         * Concurrency mode to use with state operations.
         * 
         * The option is a: {@code
         * io.dapr.client.domain.StateOptions.Concurrency} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprConcurrency}.
         */
        public String daprConcurrency() {
            return "CamelDaprConcurrency";
        }
        /**
         * Consistency level to use with state operations.
         * 
         * The option is a: {@code
         * io.dapr.client.domain.StateOptions.Consistency} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprConsistency}.
         */
        public String daprConsistency() {
            return "CamelDaprConsistency";
        }
        /**
         * Additional key-value pairs to be passed to the state store.
         * 
         * The option is a: {@code Map<String, String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprMetadata}.
         */
        public String daprMetadata() {
            return "CamelDaprMetadata";
        }
        /**
         * List of states for bulk save operation.
         * 
         * The option is a: {@code List<State<?>>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprStates}.
         */
        public String daprStates() {
            return "CamelDaprStates";
        }
        /**
         * List of keys for bulk get operation.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprKeys}.
         */
        public String daprKeys() {
            return "CamelDaprKeys";
        }
        /**
         * List of transactions for execute transactions state operations.
         * 
         * The option is a: {@code List<TransactionalStateOperation<?>>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprTransactions}.
         */
        public String daprTransactions() {
            return "CamelDaprTransactions";
        }
        /**
         * The name of the Dapr Pub/Sub component to use. This identifies which
         * underlying messaging system Dapr will interact with for publishing or
         * subscribing to events.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DaprPubSubName}.
         */
        public String daprPubSubName() {
            return "CamelDaprPubSubName";
        }
        /**
         * The name of the topic to subscribe to. The topic must exist in the
         * Pub/Sub component configured under the given pubsubName.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DaprTopic}.
         */
        public String daprTopic() {
            return "CamelDaprTopic";
        }
        /**
         * The content type for the Pub/Sub component to use.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DaprContentType}.
         */
        public String daprContentType() {
            return "CamelDaprContentType";
        }
        /**
         * Gets the unique identifier for the event, used to distinguish it from
         * other events.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprID}.
         */
        public String daprID() {
            return "CamelDaprID";
        }
        /**
         * Gets the origin of the event, typically a URI indicating the
         * component or service that generated the event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprSource}.
         */
        public String daprSource() {
            return "CamelDaprSource";
        }
        /**
         * Gets the string indicating the type of cloud event.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprType}.
         */
        public String daprType() {
            return "CamelDaprType";
        }
        /**
         * Gets the version of the CloudEvents specification that the event
         * conforms to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprSpecificVersion}.
         */
        public String daprSpecificVersion() {
            return "CamelDaprSpecificVersion";
        }
        /**
         * Gets the content type of the event data.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprDataContentType}.
         */
        public String daprDataContentType() {
            return "CamelDaprDataContentType";
        }
        /**
         * Gets the raw binary data payload of the event, if present (for events
         * where data_base64 is used instead of data).
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprBinaryData}.
         */
        public String daprBinaryData() {
            return "CamelDaprBinaryData";
        }
        /**
         * Gets the timestamp of when the event occurred.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprTime}.
         */
        public String daprTime() {
            return "CamelDaprTime";
        }
        /**
         * Gets tracing info for following the event across services (includes
         * trace ID and span ID).
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprTraceParent}.
         */
        public String daprTraceParent() {
            return "CamelDaprTraceParent";
        }
        /**
         * Gets additional vendor-specific trace context.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprTraceState}.
         */
        public String daprTraceState() {
            return "CamelDaprTraceState";
        }
        /**
         * The name of the Dapr binding to invoke.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprBindingName}.
         */
        public String daprBindingName() {
            return "CamelDaprBindingName";
        }
        /**
         * The operation to perform on the binding.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprBindingOperation}.
         */
        public String daprBindingOperation() {
            return "CamelDaprBindingOperation";
        }
        /**
         * List of keys for configuration operation.
         * 
         * The option is a: {@code List<String>} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code DaprConfigKeys}.
         */
        public String daprConfigKeys() {
            return "CamelDaprConfigKeys";
        }
        /**
         * The id for configuration change subscription.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code DaprSubscriptionId}.
         */
        public String daprSubscriptionId() {
            return "CamelDaprSubscriptionId";
        }
        /**
         * The raw configuration update response.
         * 
         * The option is a: {@code Map<String,
         * io.dapr.client.domain.ConfigurationItem} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code DaprRawConfigResponse}.
         */
        public String daprRawConfigResponse() {
            return "CamelDaprRawConfigResponse";
        }
    }
    static DaprEndpointBuilder endpointBuilder(String componentName, String path) {
        class DaprEndpointBuilderImpl extends AbstractEndpointBuilder implements DaprEndpointBuilder, AdvancedDaprEndpointBuilder {
            public DaprEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new DaprEndpointBuilderImpl(path);
    }
}