/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.debezium.sqlserver.DebeziumSqlserverComponent;

/**
 * Capture changes from an SQL Server database.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface DebeziumSqlserverComponentBuilderFactory {

    /**
     * Debezium SQL Server Connector (camel-debezium-sqlserver)
     * Capture changes from an SQL Server database.
     * 
     * Category: database
     * Since: 3.0
     * Maven coordinates: org.apache.camel:camel-debezium-sqlserver
     * 
     * @return the dsl builder
     */
    static DebeziumSqlserverComponentBuilder debeziumSqlserver() {
        return new DebeziumSqlserverComponentBuilderImpl();
    }

    /**
     * Builder for the Debezium SQL Server Connector component.
     */
    interface DebeziumSqlserverComponentBuilder extends ComponentBuilder<DebeziumSqlserverComponent> {
    
        /**
         * Additional properties for debezium components in case they can't be
         * set directly on the camel configurations (e.g: setting Kafka Connect
         * properties needed by Debezium engine, for example setting
         * KafkaOffsetBackingStore), the properties have to be prefixed with
         * additionalProperties.. E.g:
         * additionalProperties.transactional.id=12345&amp;additionalProperties.schema.registry.url=http://localhost:8811/avro.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param additionalProperties the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder additionalProperties(java.util.Map<java.lang.String, java.lang.Object> additionalProperties) {
            doSetProperty("additionalProperties", additionalProperties);
            return this;
        }
    
        
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions (if possible) occurred while the Camel
         * consumer is trying to pickup incoming messages, or the likes, will
         * now be processed as a message and handled by the routing Error
         * Handler. Important: This is only possible if the 3rd party component
         * allows Camel to be alerted if an exception was thrown. Some
         * components handle this internally only, and therefore
         * bridgeErrorHandler is not possible. In other situations we may
         * improve the Camel component to hook into the 3rd party component and
         * make this possible for future releases. By default the consumer will
         * use the org.apache.camel.spi.ExceptionHandler to deal with
         * exceptions, that will be logged at WARN or ERROR level and ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
    
        /**
         * Allow pre-configured Configurations to be set.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.debezium.sqlserver.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder configuration(org.apache.camel.component.debezium.sqlserver.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * key data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalKeyConverter the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder internalKeyConverter(java.lang.String internalKeyConverter) {
            doSetProperty("internalKeyConverter", internalKeyConverter);
            return this;
        }
    
        
        /**
         * The Converter class that should be used to serialize and deserialize
         * value data for offsets. The default is JSON converter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.json.JsonConverter
         * Group: consumer
         * 
         * @param internalValueConverter the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder internalValueConverter(java.lang.String internalValueConverter) {
            doSetProperty("internalValueConverter", internalValueConverter);
            return this;
        }
    
        /**
         * The name of the Java class of the commit policy. It defines when
         * offsets commit has to be triggered based on the number of events
         * processed and the time elapsed since the last commit. This class must
         * implement the interface 'OffsetCommitPolicy'. The default is a
         * periodic commit policy based upon time intervals.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetCommitPolicy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetCommitPolicy(java.lang.String offsetCommitPolicy) {
            doSetProperty("offsetCommitPolicy", offsetCommitPolicy);
            return this;
        }
    
        
        /**
         * Maximum number of milliseconds to wait for records to flush and
         * partition offset data to be committed to offset storage before
         * cancelling the process and restoring the offset data to be committed
         * in a future attempt. The default is 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5000
         * Group: consumer
         * 
         * @param offsetCommitTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetCommitTimeoutMs(long offsetCommitTimeoutMs) {
            doSetProperty("offsetCommitTimeoutMs", offsetCommitTimeoutMs);
            return this;
        }
    
        
        /**
         * Interval at which to try committing offsets. The default is 1 minute.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 60000
         * Group: consumer
         * 
         * @param offsetFlushIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetFlushIntervalMs(long offsetFlushIntervalMs) {
            doSetProperty("offsetFlushIntervalMs", offsetFlushIntervalMs);
            return this;
        }
    
        
        /**
         * The name of the Java class that is responsible for persistence of
         * connector offsets.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: org.apache.kafka.connect.storage.FileOffsetBackingStore
         * Group: consumer
         * 
         * @param offsetStorage the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetStorage(java.lang.String offsetStorage) {
            doSetProperty("offsetStorage", offsetStorage);
            return this;
        }
    
        /**
         * Path to file where offsets are to be stored. Required when
         * offset.storage is set to the FileOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageFileName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetStorageFileName(java.lang.String offsetStorageFileName) {
            doSetProperty("offsetStorageFileName", offsetStorageFileName);
            return this;
        }
    
        /**
         * The number of partitions used when creating the offset storage topic.
         * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStoragePartitions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetStoragePartitions(int offsetStoragePartitions) {
            doSetProperty("offsetStoragePartitions", offsetStoragePartitions);
            return this;
        }
    
        /**
         * Replication factor used when creating the offset storage topic.
         * Required when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageReplicationFactor the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetStorageReplicationFactor(int offsetStorageReplicationFactor) {
            doSetProperty("offsetStorageReplicationFactor", offsetStorageReplicationFactor);
            return this;
        }
    
        /**
         * The name of the Kafka topic where offsets are to be stored. Required
         * when offset.storage is set to the KafkaOffsetBackingStore.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param offsetStorageTopic the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder offsetStorageTopic(java.lang.String offsetStorageTopic) {
            doSetProperty("offsetStorageTopic", offsetStorageTopic);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        
        /**
         * Specify how binary (blob, binary, etc.) columns should be represented
         * in change events, including: 'bytes' represents binary data as byte
         * array (default); 'base64' represents binary data as base64-encoded
         * string; 'base64-url-safe' represents binary data as
         * base64-url-safe-encoded string; 'hex' represents binary data as
         * hex-encoded (base16) string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: bytes
         * Group: sqlserver
         * 
         * @param binaryHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder binaryHandlingMode(java.lang.String binaryHandlingMode) {
            doSetProperty("binaryHandlingMode", binaryHandlingMode);
            return this;
        }
    
        /**
         * Regular expressions matching columns to exclude from change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param columnExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder columnExcludeList(java.lang.String columnExcludeList) {
            doSetProperty("columnExcludeList", columnExcludeList);
            return this;
        }
    
        /**
         * Regular expressions matching columns to include in change events.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param columnIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder columnIncludeList(java.lang.String columnIncludeList) {
            doSetProperty("columnIncludeList", columnIncludeList);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching
         * fully-qualified names of columns that adds the columns original type
         * and original length as parameters to the corresponding field schemas
         * in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param columnPropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder columnPropagateSourceType(java.lang.String columnPropagateSourceType) {
            doSetProperty("columnPropagateSourceType", columnPropagateSourceType);
            return this;
        }
    
        /**
         * Optional list of custom converters that would be used instead of
         * default ones. The converters are defined using '.type' config option
         * and configured using options '.'.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param converters the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder converters(java.lang.String converters) {
            doSetProperty("converters", converters);
            return this;
        }
    
        /**
         * The custom metric tags will accept key-value pairs to customize the
         * MBean object name which should be appended the end of regular name,
         * each key would represent a tag for the MBean object name, and the
         * corresponding value would be the value of that tag the key is. For
         * example: k1=v1,k2=v2.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param customMetricTags the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder customMetricTags(java.lang.String customMetricTags) {
            doSetProperty("customMetricTags", customMetricTags);
            return this;
        }
    
        /**
         * Resolvable hostname or IP address of the database server.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param databaseHostname the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databaseHostname(java.lang.String databaseHostname) {
            doSetProperty("databaseHostname", databaseHostname);
            return this;
        }
    
        /**
         * The SQL Server instance name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param databaseInstance the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databaseInstance(java.lang.String databaseInstance) {
            doSetProperty("databaseInstance", databaseInstance);
            return this;
        }
    
        /**
         * The names of the databases from which the connector should capture
         * changes.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param databaseNames the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databaseNames(java.lang.String databaseNames) {
            doSetProperty("databaseNames", databaseNames);
            return this;
        }
    
        /**
         * Password of the database user to be used when connecting to the
         * database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param databasePassword the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databasePassword(java.lang.String databasePassword) {
            doSetProperty("databasePassword", databasePassword);
            return this;
        }
    
        
        /**
         * Port of the database server.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1433
         * Group: sqlserver
         * 
         * @param databasePort the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databasePort(int databasePort) {
            doSetProperty("databasePort", databasePort);
            return this;
        }
    
        
        /**
         * Time to wait for a query to execute, given in milliseconds. Defaults
         * to 600 seconds (600,000 ms); zero means there is no limit.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 10m
         * Group: sqlserver
         * 
         * @param databaseQueryTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
            doSetProperty("databaseQueryTimeoutMs", databaseQueryTimeoutMs);
            return this;
        }
    
        /**
         * Name of the database user to be used when connecting to the database.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param databaseUser the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder databaseUser(java.lang.String databaseUser) {
            doSetProperty("databaseUser", databaseUser);
            return this;
        }
    
        
        /**
         * Controls how the connector queries CDC data. The default is
         * 'function', which means the data is queried by means of calling
         * cdc.fn_cdc_get_all_changes_# function. The value of 'direct' makes
         * the connector to query the change tables directly.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: function
         * Group: sqlserver
         * 
         * @param dataQueryMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder dataQueryMode(java.lang.String dataQueryMode) {
            doSetProperty("dataQueryMode", dataQueryMode);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions matching the
         * database-specific data type names that adds the data type's original
         * type and original length as parameters to the corresponding field
         * schemas in the emitted change records.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param datatypePropagateSourceType the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder datatypePropagateSourceType(java.lang.String datatypePropagateSourceType) {
            doSetProperty("datatypePropagateSourceType", datatypePropagateSourceType);
            return this;
        }
    
        
        /**
         * Specify how DECIMAL and NUMERIC columns should be represented in
         * change events, including: 'precise' (the default) uses
         * java.math.BigDecimal to represent values, which are encoded in the
         * change events using a binary representation and Kafka Connect's
         * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
         * represent values; 'double' represents values using Java's 'double',
         * which may not offer the precision but will be far easier to use in
         * consumers.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: precise
         * Group: sqlserver
         * 
         * @param decimalHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder decimalHandlingMode(java.lang.String decimalHandlingMode) {
            doSetProperty("decimalHandlingMode", decimalHandlingMode);
            return this;
        }
    
        
        /**
         * The maximum number of retries on connection errors before failing (-1
         * = no limit, 0 = disabled, 0 = num of retries).
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: sqlserver
         * 
         * @param errorsMaxRetries the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder errorsMaxRetries(int errorsMaxRetries) {
            doSetProperty("errorsMaxRetries", errorsMaxRetries);
            return this;
        }
    
        
        /**
         * Specify how failures during processing of events (i.e. when
         * encountering a corrupted event) should be handled, including: 'fail'
         * (the default) an exception indicating the problematic event and its
         * position is raised, causing the connector to be stopped; 'warn' the
         * problematic event and its position will be logged and the event will
         * be skipped; 'ignore' the problematic event will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: fail
         * Group: sqlserver
         * 
         * @param eventProcessingFailureHandlingMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder eventProcessingFailureHandlingMode(java.lang.String eventProcessingFailureHandlingMode) {
            doSetProperty("eventProcessingFailureHandlingMode", eventProcessingFailureHandlingMode);
            return this;
        }
    
        /**
         * The query executed with every heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param heartbeatActionQuery the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder heartbeatActionQuery(java.lang.String heartbeatActionQuery) {
            doSetProperty("heartbeatActionQuery", heartbeatActionQuery);
            return this;
        }
    
        
        /**
         * Length of an interval in milli-seconds in in which the connector
         * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
         * disable heartbeat messages. Disabled by default.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param heartbeatIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder heartbeatIntervalMs(int heartbeatIntervalMs) {
            doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }
    
        
        /**
         * The prefix that is used to name heartbeat topics.Defaults to
         * __debezium-heartbeat.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: __debezium-heartbeat
         * Group: sqlserver
         * 
         * @param heartbeatTopicsPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder heartbeatTopicsPrefix(java.lang.String heartbeatTopicsPrefix) {
            doSetProperty("heartbeatTopicsPrefix", heartbeatTopicsPrefix);
            return this;
        }
    
        
        /**
         * Whether the connector should publish changes in the database schema
         * to a Kafka topic with the same name as the database server ID. Each
         * schema change will be recorded using a key that contains the database
         * name and whose value include logical description of the new schema
         * and optionally the DDL statement(s). The default is 'true'. This is
         * independent of how the connector internally records database schema
         * history.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param includeSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder includeSchemaChanges(boolean includeSchemaChanges) {
            doSetProperty("includeSchemaChanges", includeSchemaChanges);
            return this;
        }
    
        
        /**
         * Whether the connector parse table and column's comment to metadata
         * object. Note: Enable this option will bring the implications on
         * memory usage. The number and size of ColumnImpl objects is what
         * largely impacts how much memory is consumed by the Debezium
         * connectors, and adding a String to each of them can potentially be
         * quite heavy. The default is 'false'.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param includeSchemaComments the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder includeSchemaComments(boolean includeSchemaComments) {
            doSetProperty("includeSchemaComments", includeSchemaComments);
            return this;
        }
    
        
        /**
         * Detect schema change during an incremental snapshot and re-select a
         * current chunk to avoid locking DDLs. Note that changes to a primary
         * key are not supported and can cause incorrect results if performed
         * during an incremental snapshot. Another limitation is that if a
         * schema change affects only columns' default values, then the change
         * won't be detected until the DDL is processed from the binlog stream.
         * This doesn't affect the snapshot events' values, but the schema of
         * snapshot events may have outdated defaults.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotAllowSchemaChanges the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder incrementalSnapshotAllowSchemaChanges(boolean incrementalSnapshotAllowSchemaChanges) {
            doSetProperty("incrementalSnapshotAllowSchemaChanges", incrementalSnapshotAllowSchemaChanges);
            return this;
        }
    
        
        /**
         * The maximum size of chunk (number of documents/rows) for incremental
         * snapshotting.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1024
         * Group: sqlserver
         * 
         * @param incrementalSnapshotChunkSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder incrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
            doSetProperty("incrementalSnapshotChunkSize", incrementalSnapshotChunkSize);
            return this;
        }
    
        
        /**
         * Add OPTION(RECOMPILE) on each SELECT statement during the incremental
         * snapshot process. This prevents parameter sniffing but can cause CPU
         * pressure on the source database.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param incrementalSnapshotOptionRecompile the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder incrementalSnapshotOptionRecompile(boolean incrementalSnapshotOptionRecompile) {
            doSetProperty("incrementalSnapshotOptionRecompile", incrementalSnapshotOptionRecompile);
            return this;
        }
    
        
        /**
         * Specify the strategy used for watermarking during an incremental
         * snapshot: 'insert_insert' both open and close signal is written into
         * signal data collection (default); 'insert_delete' only open signal is
         * written on signal data collection, the close will delete the relative
         * open signal;.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: INSERT_INSERT
         * Group: sqlserver
         * 
         * @param incrementalSnapshotWatermarkingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder incrementalSnapshotWatermarkingStrategy(java.lang.String incrementalSnapshotWatermarkingStrategy) {
            doSetProperty("incrementalSnapshotWatermarkingStrategy", incrementalSnapshotWatermarkingStrategy);
            return this;
        }
    
        
        /**
         * Maximum size of each batch of source records. Defaults to 2048.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 2048
         * Group: sqlserver
         * 
         * @param maxBatchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder maxBatchSize(int maxBatchSize) {
            doSetProperty("maxBatchSize", maxBatchSize);
            return this;
        }
    
        
        /**
         * This property can be used to reduce the connector memory usage
         * footprint when changes are streamed from multiple tables per
         * database.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: sqlserver
         * 
         * @param maxIterationTransactions the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder maxIterationTransactions(int maxIterationTransactions) {
            doSetProperty("maxIterationTransactions", maxIterationTransactions);
            return this;
        }
    
        
        /**
         * Maximum size of the queue for change events read from the database
         * log but not yet recorded or forwarded. Defaults to 8192, and should
         * always be larger than the maximum batch size.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: sqlserver
         * 
         * @param maxQueueSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder maxQueueSize(int maxQueueSize) {
            doSetProperty("maxQueueSize", maxQueueSize);
            return this;
        }
    
        /**
         * Maximum size of the queue in bytes for change events read from the
         * database log but not yet recorded or forwarded. Defaults to 0. Mean
         * the feature is not enabled.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param maxQueueSizeInBytes the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder maxQueueSizeInBytes(long maxQueueSizeInBytes) {
            doSetProperty("maxQueueSizeInBytes", maxQueueSizeInBytes);
            return this;
        }
    
        /**
         * A semicolon-separated list of expressions that match fully-qualified
         * tables and column(s) to be used as message key. Each expression must
         * match the pattern ':', where the table names could be defined as
         * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
         * specific connector, and the key columns are a comma-separated list of
         * columns representing the custom key. For any table without an
         * explicit key configuration the table's primary key column(s) will be
         * used as message key. Example:
         * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param messageKeyColumns the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder messageKeyColumns(java.lang.String messageKeyColumns) {
            doSetProperty("messageKeyColumns", messageKeyColumns);
            return this;
        }
    
        /**
         * List of notification channels names that are enabled.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param notificationEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder notificationEnabledChannels(java.lang.String notificationEnabledChannels) {
            doSetProperty("notificationEnabledChannels", notificationEnabledChannels);
            return this;
        }
    
        /**
         * The name of the topic for the notifications. This is required in case
         * 'sink' is in the list of enabled channels.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param notificationSinkTopicName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder notificationSinkTopicName(java.lang.String notificationSinkTopicName) {
            doSetProperty("notificationSinkTopicName", notificationSinkTopicName);
            return this;
        }
    
        
        /**
         * Time to wait for new change events to appear after receiving no
         * events, given in milliseconds. Defaults to 500 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500ms
         * Group: sqlserver
         * 
         * @param pollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder pollIntervalMs(long pollIntervalMs) {
            doSetProperty("pollIntervalMs", pollIntervalMs);
            return this;
        }
    
        /**
         * Optional list of post processors. The processors are defined using
         * '.type' config option and configured using options ''.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param postProcessors the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder postProcessors(java.lang.String postProcessors) {
            doSetProperty("postProcessors", postProcessors);
            return this;
        }
    
        
        /**
         * Enables transaction metadata extraction together with event counting.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param provideTransactionMetadata the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder provideTransactionMetadata(boolean provideTransactionMetadata) {
            doSetProperty("provideTransactionMetadata", provideTransactionMetadata);
            return this;
        }
    
        
        /**
         * Time to wait before restarting connector after retriable exception
         * occurs. Defaults to 10000ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param retriableRestartConnectorWaitMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder retriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
            doSetProperty("retriableRestartConnectorWaitMs", retriableRestartConnectorWaitMs);
            return this;
        }
    
        
        /**
         * The name of the SchemaHistory class that should be used to store and
         * recover database schema changes. The configuration properties for the
         * history are prefixed with the 'schema.history.internal.' string.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.storage.kafka.history.KafkaSchemaHistory
         * Group: sqlserver
         * 
         * @param schemaHistoryInternal the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaHistoryInternal(java.lang.String schemaHistoryInternal) {
            doSetProperty("schemaHistoryInternal", schemaHistoryInternal);
            return this;
        }
    
        /**
         * The path to the file that will be used to record the database schema
         * history.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalFileFilename the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaHistoryInternalFileFilename(java.lang.String schemaHistoryInternalFileFilename) {
            doSetProperty("schemaHistoryInternalFileFilename", schemaHistoryInternalFileFilename);
            return this;
        }
    
        
        /**
         * Controls the action Debezium will take when it meets a DDL statement
         * in binlog, that it cannot parse.By default the connector will stop
         * operating but by changing the setting it can ignore the statements
         * which it cannot parse. If skipping is enabled then Debezium can miss
         * metadata changes.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalSkipUnparseableDdl the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
            doSetProperty("schemaHistoryInternalSkipUnparseableDdl", schemaHistoryInternalSkipUnparseableDdl);
            return this;
        }
    
        
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a table from captured
         * schema/database will be stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedDatabasesDdl the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedDatabasesDdl", schemaHistoryInternalStoreOnlyCapturedDatabasesDdl);
            return this;
        }
    
        
        /**
         * Controls what DDL will Debezium store in database schema history. By
         * default (false) Debezium will store all incoming DDL statements. If
         * set to true, then only DDL that manipulates a captured table will be
         * stored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param schemaHistoryInternalStoreOnlyCapturedTablesDdl the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
            doSetProperty("schemaHistoryInternalStoreOnlyCapturedTablesDdl", schemaHistoryInternalStoreOnlyCapturedTablesDdl);
            return this;
        }
    
        
        /**
         * Specify how schema names should be adjusted for compatibility with
         * the message converter used by the connector, including: 'avro'
         * replaces the characters that cannot be used in the Avro type name
         * with underscore; 'avro_unicode' replaces the underscore or characters
         * that cannot be used in the Avro type name with corresponding unicode
         * like _uxxxx. Note: _ is an escape sequence like backslash in
         * Java;'none' does not apply any adjustment (default).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: none
         * Group: sqlserver
         * 
         * @param schemaNameAdjustmentMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder schemaNameAdjustmentMode(java.lang.String schemaNameAdjustmentMode) {
            doSetProperty("schemaNameAdjustmentMode", schemaNameAdjustmentMode);
            return this;
        }
    
        /**
         * The name of the data collection that is used to send signals/commands
         * to Debezium. Signaling is disabled when not set.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param signalDataCollection the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder signalDataCollection(java.lang.String signalDataCollection) {
            doSetProperty("signalDataCollection", signalDataCollection);
            return this;
        }
    
        
        /**
         * List of channels names that are enabled. Source channel is enabled by
         * default.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: source
         * Group: sqlserver
         * 
         * @param signalEnabledChannels the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder signalEnabledChannels(java.lang.String signalEnabledChannels) {
            doSetProperty("signalEnabledChannels", signalEnabledChannels);
            return this;
        }
    
        
        /**
         * Interval for looking for new signals in registered channels, given in
         * milliseconds. Defaults to 5 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 5s
         * Group: sqlserver
         * 
         * @param signalPollIntervalMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder signalPollIntervalMs(long signalPollIntervalMs) {
            doSetProperty("signalPollIntervalMs", signalPollIntervalMs);
            return this;
        }
    
        
        /**
         * The comma-separated list of operations to skip during streaming,
         * defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes,
         * 't' for truncates, and 'none' to indicate nothing skipped. By
         * default, only truncate operations will be skipped.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: t
         * Group: sqlserver
         * 
         * @param skippedOperations the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder skippedOperations(java.lang.String skippedOperations) {
            doSetProperty("skippedOperations", skippedOperations);
            return this;
        }
    
        
        /**
         * A delay period before a snapshot will begin, given in milliseconds.
         * Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param snapshotDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotDelayMs(long snapshotDelayMs) {
            doSetProperty("snapshotDelayMs", snapshotDelayMs);
            return this;
        }
    
        /**
         * The maximum number of records that should be loaded into memory while
         * performing a snapshot.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotFetchSize(int snapshotFetchSize) {
            doSetProperty("snapshotFetchSize", snapshotFetchSize);
            return this;
        }
    
        /**
         * This setting must be set to specify a list of tables/collections
         * whose snapshot must be taken on creating or restarting the connector.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotIncludeCollectionList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotIncludeCollectionList(java.lang.String snapshotIncludeCollectionList) {
            doSetProperty("snapshotIncludeCollectionList", snapshotIncludeCollectionList);
            return this;
        }
    
        
        /**
         * Controls which transaction isolation level is used and how long the
         * connector locks the captured tables. The default is
         * 'repeatable_read', which means that repeatable read isolation level
         * is used. In addition, type of acquired lock during schema snapshot
         * depends on snapshot.locking.mode property. Using a value of
         * 'exclusive' ensures that the connector holds the type of lock
         * specified with snapshot.locking.mode property (and thus prevents any
         * reads and updates) for all captured tables during the entire snapshot
         * duration. When 'snapshot' is specified, connector runs the initial
         * snapshot in SNAPSHOT isolation level, which guarantees snapshot
         * consistency. In addition, neither table nor row-level locks are held.
         * When 'read_committed' is specified, connector runs the initial
         * snapshot in READ COMMITTED isolation level. No long-running locks are
         * taken, so that initial snapshot does not prevent other transactions
         * from updating table rows. Snapshot consistency is not guaranteed.In
         * 'read_uncommitted' mode neither table nor row-level locks are
         * acquired, but connector does not guarantee snapshot consistency.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: repeatable_read
         * Group: sqlserver
         * 
         * @param snapshotIsolationMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotIsolationMode(java.lang.String snapshotIsolationMode) {
            doSetProperty("snapshotIsolationMode", snapshotIsolationMode);
            return this;
        }
    
        
        /**
         * The maximum number of millis to wait for table locks at the beginning
         * of a snapshot. If locks cannot be acquired in this time frame, the
         * snapshot will be aborted. Defaults to 10 seconds.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 10s
         * Group: sqlserver
         * 
         * @param snapshotLockTimeoutMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
            doSetProperty("snapshotLockTimeoutMs", snapshotLockTimeoutMs);
            return this;
        }
    
        
        /**
         * The maximum number of threads used to perform the snapshot. Defaults
         * to 1.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 1
         * Group: sqlserver
         * 
         * @param snapshotMaxThreads the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotMaxThreads(int snapshotMaxThreads) {
            doSetProperty("snapshotMaxThreads", snapshotMaxThreads);
            return this;
        }
    
        
        /**
         * The criteria for running a snapshot upon startup of the connector.
         * Select one of the following snapshot options: 'initial' (default): If
         * the connector does not detect any offsets for the logical server
         * name, it runs a snapshot that captures the current full state of the
         * configured tables. After the snapshot completes, the connector begins
         * to stream changes from the transaction log.; 'initial_only': The
         * connector performs a snapshot as it does for the 'initial' option,
         * but after the connector completes the snapshot, it stops, and does
         * not stream changes from the transaction log.; 'schema_only': If the
         * connector does not detect any offsets for the logical server name, it
         * runs a snapshot that captures only the schema (table structures), but
         * not any table data. After the snapshot completes, the connector
         * begins to stream changes from the transaction log.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: initial
         * Group: sqlserver
         * 
         * @param snapshotMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotMode(java.lang.String snapshotMode) {
            doSetProperty("snapshotMode", snapshotMode);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotData the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotData", snapshotModeConfigurationBasedSnapshotData);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the data should be snapshotted or not in
         * case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnDataError the value to
         * set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnDataError", snapshotModeConfigurationBasedSnapshotOnDataError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not
         * in case of error.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotOnSchemaError the value
         * to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotOnSchemaError", snapshotModeConfigurationBasedSnapshotOnSchemaError);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the schema should be snapshotted or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedSnapshotSchema the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
            doSetProperty("snapshotModeConfigurationBasedSnapshotSchema", snapshotModeConfigurationBasedSnapshotSchema);
            return this;
        }
    
        
        /**
         * When 'snapshot.mode' is set as configuration_based, this setting
         * permits to specify whenever the stream should start or not after
         * snapshot.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param snapshotModeConfigurationBasedStartStream the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
            doSetProperty("snapshotModeConfigurationBasedStartStream", snapshotModeConfigurationBasedStartStream);
            return this;
        }
    
        /**
         * When 'snapshot.mode' is set as custom, this setting must be set to
         * specify a the name of the custom implementation provided in the
         * 'name()' method. The implementations must implement the 'Snapshotter'
         * interface and is called on each app boot to determine whether to do a
         * snapshot.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotModeCustomName the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotModeCustomName(java.lang.String snapshotModeCustomName) {
            doSetProperty("snapshotModeCustomName", snapshotModeCustomName);
            return this;
        }
    
        /**
         * This property contains a comma-separated list of fully-qualified
         * tables (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
         * the specific connectors. Select statements for the individual tables
         * are specified in further configuration properties, one for each
         * table, identified by the id
         * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
         * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
         * respectively. The value of those properties is the select statement
         * to use when retrieving data from the specific table during
         * snapshotting. A possible use case for large append-only tables is
         * setting a specific point where to start (resume) snapshotting, in
         * case a previous snapshotting was interrupted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param snapshotSelectStatementOverrides the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotSelectStatementOverrides(java.lang.String snapshotSelectStatementOverrides) {
            doSetProperty("snapshotSelectStatementOverrides", snapshotSelectStatementOverrides);
            return this;
        }
    
        
        /**
         * Controls the order in which tables are processed in the initial
         * snapshot. A descending value will order the tables by row count
         * descending. A ascending value will order the tables by row count
         * ascending. A value of disabled (the default) will disable ordering by
         * row count.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: disabled
         * Group: sqlserver
         * 
         * @param snapshotTablesOrderByRowCount the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder snapshotTablesOrderByRowCount(java.lang.String snapshotTablesOrderByRowCount) {
            doSetProperty("snapshotTablesOrderByRowCount", snapshotTablesOrderByRowCount);
            return this;
        }
    
        
        /**
         * The name of the SourceInfoStructMaker class that returns SourceInfo
         * schema and struct.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * io.debezium.connector.sqlserver.SqlServerSourceInfoStructMaker
         * Group: sqlserver
         * 
         * @param sourceinfoStructMaker the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder sourceinfoStructMaker(java.lang.String sourceinfoStructMaker) {
            doSetProperty("sourceinfoStructMaker", sourceinfoStructMaker);
            return this;
        }
    
        
        /**
         * A delay period after the snapshot is completed and the streaming
         * begins, given in milliseconds. Defaults to 0 ms.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0ms
         * Group: sqlserver
         * 
         * @param streamingDelayMs the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder streamingDelayMs(long streamingDelayMs) {
            doSetProperty("streamingDelayMs", streamingDelayMs);
            return this;
        }
    
        /**
         * Specifies the maximum number of rows that should be read in one go
         * from each table while streaming. The connector will read the table
         * contents in multiple batches of this size. Defaults to 0 which means
         * no limit.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param streamingFetchSize the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder streamingFetchSize(int streamingFetchSize) {
            doSetProperty("streamingFetchSize", streamingFetchSize);
            return this;
        }
    
        /**
         * A comma-separated list of regular expressions that match the
         * fully-qualified names of tables to be excluded from monitoring.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param tableExcludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder tableExcludeList(java.lang.String tableExcludeList) {
            doSetProperty("tableExcludeList", tableExcludeList);
            return this;
        }
    
        
        /**
         * Flag specifying whether built-in tables should be ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: sqlserver
         * 
         * @param tableIgnoreBuiltin the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder tableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
            doSetProperty("tableIgnoreBuiltin", tableIgnoreBuiltin);
            return this;
        }
    
        /**
         * The tables for which changes are to be captured.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param tableIncludeList the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder tableIncludeList(java.lang.String tableIncludeList) {
            doSetProperty("tableIncludeList", tableIncludeList);
            return this;
        }
    
        
        /**
         * Time, date, and timestamps can be represented with different kinds of
         * precisions, including: 'adaptive' (the default) bases the precision
         * of time, date, and timestamp values on the database column's
         * precision; 'adaptive_time_microseconds' like 'adaptive' mode, but
         * TIME fields always use microseconds precision; 'connect' always
         * represents time, date, and timestamp values using Kafka Connect's
         * built-in representations for Time, Date, and Timestamp, which uses
         * millisecond precision regardless of the database columns' precision.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: adaptive
         * Group: sqlserver
         * 
         * @param timePrecisionMode the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder timePrecisionMode(java.lang.String timePrecisionMode) {
            doSetProperty("timePrecisionMode", timePrecisionMode);
            return this;
        }
    
        
        /**
         * Whether delete operations should be represented by a delete event and
         * a subsequent tombstone event (true) or only by a delete event
         * (false). Emitting the tombstone event (the default behavior) allows
         * Kafka to completely delete all events pertaining to the given key
         * once the source record got deleted.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: sqlserver
         * 
         * @param tombstonesOnDelete the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder tombstonesOnDelete(boolean tombstonesOnDelete) {
            doSetProperty("tombstonesOnDelete", tombstonesOnDelete);
            return this;
        }
    
        
        /**
         * The name of the TopicNamingStrategy class that should be used to
         * determine the topic name for data change, schema change, transaction,
         * heartbeat event etc.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: io.debezium.schema.SchemaTopicNamingStrategy
         * Group: sqlserver
         * 
         * @param topicNamingStrategy the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder topicNamingStrategy(java.lang.String topicNamingStrategy) {
            doSetProperty("topicNamingStrategy", topicNamingStrategy);
            return this;
        }
    
        /**
         * Topic prefix that identifies and provides a namespace for the
         * particular database server/cluster is capturing changes. The topic
         * prefix should be unique across all other connectors, since it is used
         * as a prefix for all Kafka topic names that receive events emitted by
         * this connector. Only alphanumeric characters, hyphens, dots and
         * underscores must be accepted.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: sqlserver
         * 
         * @param topicPrefix the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder topicPrefix(java.lang.String topicPrefix) {
            doSetProperty("topicPrefix", topicPrefix);
            return this;
        }
    
        
        /**
         * Class to make transaction context &amp; transaction struct/schemas.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default:
         * io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory
         * Group: sqlserver
         * 
         * @param transactionMetadataFactory the value to set
         * @return the dsl builder
         */
        default DebeziumSqlserverComponentBuilder transactionMetadataFactory(java.lang.String transactionMetadataFactory) {
            doSetProperty("transactionMetadataFactory", transactionMetadataFactory);
            return this;
        }
    }

    class DebeziumSqlserverComponentBuilderImpl
            extends AbstractComponentBuilder<DebeziumSqlserverComponent>
            implements DebeziumSqlserverComponentBuilder {
        @Override
        protected DebeziumSqlserverComponent buildConcreteComponent() {
            return new DebeziumSqlserverComponent();
        }
        private org.apache.camel.component.debezium.sqlserver.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration getOrCreateConfiguration(DebeziumSqlserverComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.debezium.sqlserver.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "additionalProperties": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setAdditionalProperties((java.util.Map) value); return true;
            case "bridgeErrorHandler": ((DebeziumSqlserverComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "configuration": ((DebeziumSqlserverComponent) component).setConfiguration((org.apache.camel.component.debezium.sqlserver.configuration.SqlServerConnectorEmbeddedDebeziumConfiguration) value); return true;
            case "internalKeyConverter": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setInternalKeyConverter((java.lang.String) value); return true;
            case "internalValueConverter": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setInternalValueConverter((java.lang.String) value); return true;
            case "offsetCommitPolicy": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetCommitPolicy((java.lang.String) value); return true;
            case "offsetCommitTimeoutMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetCommitTimeoutMs((long) value); return true;
            case "offsetFlushIntervalMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetFlushIntervalMs((long) value); return true;
            case "offsetStorage": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetStorage((java.lang.String) value); return true;
            case "offsetStorageFileName": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetStorageFileName((java.lang.String) value); return true;
            case "offsetStoragePartitions": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetStoragePartitions((int) value); return true;
            case "offsetStorageReplicationFactor": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetStorageReplicationFactor((int) value); return true;
            case "offsetStorageTopic": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setOffsetStorageTopic((java.lang.String) value); return true;
            case "autowiredEnabled": ((DebeziumSqlserverComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "binaryHandlingMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setBinaryHandlingMode((java.lang.String) value); return true;
            case "columnExcludeList": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setColumnExcludeList((java.lang.String) value); return true;
            case "columnIncludeList": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setColumnIncludeList((java.lang.String) value); return true;
            case "columnPropagateSourceType": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setColumnPropagateSourceType((java.lang.String) value); return true;
            case "converters": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setConverters((java.lang.String) value); return true;
            case "customMetricTags": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setCustomMetricTags((java.lang.String) value); return true;
            case "databaseHostname": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabaseHostname((java.lang.String) value); return true;
            case "databaseInstance": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabaseInstance((java.lang.String) value); return true;
            case "databaseNames": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabaseNames((java.lang.String) value); return true;
            case "databasePassword": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabasePassword((java.lang.String) value); return true;
            case "databasePort": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabasePort((int) value); return true;
            case "databaseQueryTimeoutMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabaseQueryTimeoutMs((int) value); return true;
            case "databaseUser": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatabaseUser((java.lang.String) value); return true;
            case "dataQueryMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDataQueryMode((java.lang.String) value); return true;
            case "datatypePropagateSourceType": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDatatypePropagateSourceType((java.lang.String) value); return true;
            case "decimalHandlingMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setDecimalHandlingMode((java.lang.String) value); return true;
            case "errorsMaxRetries": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setErrorsMaxRetries((int) value); return true;
            case "eventProcessingFailureHandlingMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setEventProcessingFailureHandlingMode((java.lang.String) value); return true;
            case "heartbeatActionQuery": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setHeartbeatActionQuery((java.lang.String) value); return true;
            case "heartbeatIntervalMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setHeartbeatIntervalMs((int) value); return true;
            case "heartbeatTopicsPrefix": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setHeartbeatTopicsPrefix((java.lang.String) value); return true;
            case "includeSchemaChanges": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncludeSchemaChanges((boolean) value); return true;
            case "includeSchemaComments": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncludeSchemaComments((boolean) value); return true;
            case "incrementalSnapshotAllowSchemaChanges": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncrementalSnapshotAllowSchemaChanges((boolean) value); return true;
            case "incrementalSnapshotChunkSize": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncrementalSnapshotChunkSize((int) value); return true;
            case "incrementalSnapshotOptionRecompile": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncrementalSnapshotOptionRecompile((boolean) value); return true;
            case "incrementalSnapshotWatermarkingStrategy": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setIncrementalSnapshotWatermarkingStrategy((java.lang.String) value); return true;
            case "maxBatchSize": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setMaxBatchSize((int) value); return true;
            case "maxIterationTransactions": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setMaxIterationTransactions((int) value); return true;
            case "maxQueueSize": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setMaxQueueSize((int) value); return true;
            case "maxQueueSizeInBytes": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setMaxQueueSizeInBytes((long) value); return true;
            case "messageKeyColumns": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setMessageKeyColumns((java.lang.String) value); return true;
            case "notificationEnabledChannels": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setNotificationEnabledChannels((java.lang.String) value); return true;
            case "notificationSinkTopicName": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setNotificationSinkTopicName((java.lang.String) value); return true;
            case "pollIntervalMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setPollIntervalMs((long) value); return true;
            case "postProcessors": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setPostProcessors((java.lang.String) value); return true;
            case "provideTransactionMetadata": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setProvideTransactionMetadata((boolean) value); return true;
            case "retriableRestartConnectorWaitMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setRetriableRestartConnectorWaitMs((long) value); return true;
            case "schemaHistoryInternal": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaHistoryInternal((java.lang.String) value); return true;
            case "schemaHistoryInternalFileFilename": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaHistoryInternalFileFilename((java.lang.String) value); return true;
            case "schemaHistoryInternalSkipUnparseableDdl": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaHistoryInternalSkipUnparseableDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedDatabasesDdl": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl((boolean) value); return true;
            case "schemaHistoryInternalStoreOnlyCapturedTablesDdl": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaHistoryInternalStoreOnlyCapturedTablesDdl((boolean) value); return true;
            case "schemaNameAdjustmentMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSchemaNameAdjustmentMode((java.lang.String) value); return true;
            case "signalDataCollection": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSignalDataCollection((java.lang.String) value); return true;
            case "signalEnabledChannels": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSignalEnabledChannels((java.lang.String) value); return true;
            case "signalPollIntervalMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSignalPollIntervalMs((long) value); return true;
            case "skippedOperations": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSkippedOperations((java.lang.String) value); return true;
            case "snapshotDelayMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotDelayMs((long) value); return true;
            case "snapshotFetchSize": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotFetchSize((int) value); return true;
            case "snapshotIncludeCollectionList": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotIncludeCollectionList((java.lang.String) value); return true;
            case "snapshotIsolationMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotIsolationMode((java.lang.String) value); return true;
            case "snapshotLockTimeoutMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotLockTimeoutMs((long) value); return true;
            case "snapshotMaxThreads": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotMaxThreads((int) value); return true;
            case "snapshotMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotMode((java.lang.String) value); return true;
            case "snapshotModeConfigurationBasedSnapshotData": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeConfigurationBasedSnapshotData((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnDataError": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeConfigurationBasedSnapshotOnDataError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotOnSchemaError": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeConfigurationBasedSnapshotOnSchemaError((boolean) value); return true;
            case "snapshotModeConfigurationBasedSnapshotSchema": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeConfigurationBasedSnapshotSchema((boolean) value); return true;
            case "snapshotModeConfigurationBasedStartStream": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeConfigurationBasedStartStream((boolean) value); return true;
            case "snapshotModeCustomName": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotModeCustomName((java.lang.String) value); return true;
            case "snapshotSelectStatementOverrides": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotSelectStatementOverrides((java.lang.String) value); return true;
            case "snapshotTablesOrderByRowCount": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSnapshotTablesOrderByRowCount((java.lang.String) value); return true;
            case "sourceinfoStructMaker": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setSourceinfoStructMaker((java.lang.String) value); return true;
            case "streamingDelayMs": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setStreamingDelayMs((long) value); return true;
            case "streamingFetchSize": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setStreamingFetchSize((int) value); return true;
            case "tableExcludeList": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTableExcludeList((java.lang.String) value); return true;
            case "tableIgnoreBuiltin": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTableIgnoreBuiltin((boolean) value); return true;
            case "tableIncludeList": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTableIncludeList((java.lang.String) value); return true;
            case "timePrecisionMode": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTimePrecisionMode((java.lang.String) value); return true;
            case "tombstonesOnDelete": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTombstonesOnDelete((boolean) value); return true;
            case "topicNamingStrategy": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTopicNamingStrategy((java.lang.String) value); return true;
            case "topicPrefix": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTopicPrefix((java.lang.String) value); return true;
            case "transactionMetadataFactory": getOrCreateConfiguration((DebeziumSqlserverComponent) component).setTransactionMetadataFactory((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}