/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import 'package:flutter/material.dart';

// Light Theme base colors
const Color kLightPrimaryBackground = Colors.white;
const Color kLightSecondaryBackground = Color(0xFFFCFCFC);
const Color kLightGrey = Color(0xFFE5E5E5);
const Color kLightGrey1 = Color(0xFFA0A4AB);
const Color kLightGrey2 = Color(0xFF45454E);
const Color kLightText = Color(0xFF242639);
const Color kLightPrimary = Color(0xFFE74D1A);
const Color kLightCode1 = Color(0xFFDA2833);
const Color kLightCode2 = Color(0xFF5929B4);
const Color kLightCodeComment = Color(0xFF4C6B60);

// Dark Theme base colors
const Color kDarkPrimaryBackground = Color(0xFF18181B);
const Color kDarkSecondaryBackground = Color(0xFF2E2E34);
const Color kDarkGrey = Color(0xFF3F3F46);
const Color kDarkGrey1 = Color(0xFF606772);
const Color kDarkGrey2 = Color(0xFF45454E);
const Color kDarkText = Color(0xFFFFFFFF);
const Color kDarkPrimary = Color(0xFFF26628);
const Color kDarkCode1 = Color(0xFFFB8188);
const Color kDarkCode2 = Color(0xFFC5A6FF);
const Color kDarkCodeComment = Color(0xFF8CAB9F);

// Notification colors
const Color kErrorNotificationColor = Color(0xFFE54545);
const Color kSuccessNotificationColor = Color(0xFF37AC66);
const Color kWarningNotificationColor = Color(0xFFEEAB00);
const Color kInfoNotificationColor = Color(0xFF3E67F6);

const Color kLinkColor = Color(0xFF3E67F6);
