/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.mixin;

import org.apache.axiom.core.ChildNotAllowedException;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class CoreDocumentMixin
implements CoreDocument {
    private String inputEncoding;
    private String xmlVersion = "1.0";
    private String xmlEncoding;
    private Boolean standalone;

    @Override
    public final NodeType coreGetNodeType() {
        return NodeType.DOCUMENT;
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        return this;
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (document != this) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public final CoreElement coreGetDocumentElement() throws CoreModelException {
        for (CoreChildNode child = this.coreGetFirstChild(); child != null; child = child.coreGetNextSibling()) {
            if (!(child instanceof CoreElement)) continue;
            return (CoreElement)child;
        }
        return null;
    }

    @Override
    public final String coreGetInputEncoding() {
        return this.inputEncoding;
    }

    @Override
    public final void coreSetInputEncoding(String inputEncoding) {
        this.inputEncoding = inputEncoding;
    }

    @Override
    public final String coreGetXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public final void coreSetXmlVersion(String xmlVersion) {
        this.xmlVersion = xmlVersion;
    }

    @Override
    public final String coreGetXmlEncoding() {
        return this.xmlEncoding;
    }

    @Override
    public final void coreSetXmlEncoding(String xmlEncoding) {
        this.xmlEncoding = xmlEncoding;
    }

    @Override
    public final Boolean coreGetStandalone() {
        return this.standalone;
    }

    @Override
    public final void coreSetStandalone(Boolean standalone) {
        this.standalone = standalone;
    }

    @Override
    public final <T> void init(ClonePolicy<T> policy, T options, CoreNode other) {
        CoreDocument o = (CoreDocument)other;
        this.coreSetXmlVersion(o.coreGetXmlVersion());
        this.coreSetXmlEncoding(o.coreGetXmlEncoding());
        this.coreSetStandalone(o.coreGetStandalone());
        this.coreSetInputEncoding(o.coreGetInputEncoding());
    }

    @Override
    public final void serializeStartEvent(XmlHandler handler) throws CoreModelException, StreamException {
        handler.startDocument(this.coreGetInputEncoding(), this.coreGetXmlVersion(), this.coreGetXmlEncoding(), this.coreGetStandalone());
    }

    @Override
    public final void serializeEndEvent(XmlHandler handler) throws StreamException {
        handler.completed();
    }

    final void internalCheckNewChild0(CoreChildNode newChild, CoreChildNode replacedChild) throws CoreModelException {
        if (newChild instanceof CoreElement && !(replacedChild instanceof CoreElement) && this.coreGetDocumentElement() != null) {
            throw new ChildNotAllowedException();
        }
    }
}

