/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms.ctype;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.transport.jms.ctype.ContentTypeInfo;
import org.apache.axis2.transport.jms.ctype.ContentTypeRule;

public class ContentTypeRuleSet {
    private final List<ContentTypeRule> rules = new ArrayList<ContentTypeRule>();
    private String defaultContentTypeProperty;

    public void addRule(ContentTypeRule rule) {
        this.rules.add(rule);
        if (this.defaultContentTypeProperty == null) {
            this.defaultContentTypeProperty = rule.getExpectedContentTypeProperty();
        }
    }

    public ContentTypeInfo getContentTypeInfo(Message message) throws JMSException {
        for (ContentTypeRule rule : this.rules) {
            ContentTypeInfo contentTypeInfo = rule.getContentType(message);
            if (contentTypeInfo == null) continue;
            return contentTypeInfo;
        }
        return null;
    }

    public String getDefaultContentTypeProperty() {
        return this.defaultContentTypeProperty;
    }
}

