# -*- ruby -*-
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

require_relative "lib/arrow-format/version"

Gem::Specification.new do |spec|
  spec.name = "red-arrow-format"

  version_components = [
    ArrowFormat::Version::MAJOR.to_s,
    ArrowFormat::Version::MINOR.to_s,
    ArrowFormat::Version::MICRO.to_s,
    ArrowFormat::Version::TAG,
  ]
  spec.version = version_components.compact.join(".")
  spec.homepage = "https://arrow.apache.org/"
  spec.authors = ["The Apache Software Foundation"]
  spec.email = ["dev@arrow.apache.org"]

  spec.summary = "Red Arrow Format is the pure Ruby Apache Arrow implementation"
  spec.description =
    "Apache Arrow is a common in-memory columnar data store. " +
    "It's useful to share and process large data efficiently. " +
    "Red Arrow Format provides only serialize/deserialize features. " +
    "If you want to process Apache Arrow data efficiently, " +
    "use Red Arrow instead."
  spec.license = "Apache-2.0"
  spec.files = ["README.md", "Rakefile", "Gemfile", "#{spec.name}.gemspec"]
  spec.files += ["LICENSE.txt", "NOTICE.txt"]
  spec.files += Dir.glob("lib/**/*.rb")
  spec.files += Dir.glob("doc/text/*")

  spec.add_runtime_dependency("red-flatbuffers")

  github_url = "https://github.com/apache/arrow"
  spec.metadata = {
    "bug_tracker_uri" => "#{github_url}/issues",
    "changelog_uri" => "#{github_url}/releases/tag/apache-arrow-#{spec.version}",
    "source_code_uri" => github_url,
  }
end
