% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-eval.R
\name{arrow_not_supported}
\alias{arrow_not_supported}
\alias{validation_error}
\title{Helpers to raise classed errors}
\usage{
arrow_not_supported(
  msg,
  .actual_msg = paste(msg, "not supported in Arrow"),
  ...
)

validation_error(msg, ...)
}
\arguments{
\item{msg}{The message to show. \code{arrow_not_supported()} will append
"not supported in Arrow" to this message.}

\item{.actual_msg}{If you don't want to append "not supported in Arrow" to
the message, you can provide the full message here.}

\item{...}{Additional arguments to pass to \code{rlang::abort()}. Useful arguments
include \code{call} to provide the call or expression that caused the error, and
\code{body} to provide additional context about the error.}
}
\description{
\code{arrow_not_supported()} and \code{validation_error()} raise classed errors that
allow us to distinguish between things that are not supported in Arrow and
things that are just invalid input. Additional wrapping in \code{arrow_eval()}
and \code{try_arrow_dplyr()} provide more context and suggestions.
Importantly, if \code{arrow_not_supported} is raised, then retrying the same code
in regular dplyr in R may work. But if \code{validation_error} is raised, then we
shouldn't recommend retrying with regular dplyr because it will fail there
too.
}
\details{
Use these in function bindings and in the dplyr methods. Inside of function
bindings, you don't need to provide the \code{call} argument, as it will be
automatically filled in with the expression that caused the error in
\code{arrow_eval()}. In dplyr methods, you should provide the \code{call} argument;
\code{rlang::caller_call()} often is correct, but you may need to experiment to
find how far up the call stack you need to look.

You may provide additional information in the \code{body} argument, a named
character vector. Use \code{i} for additional information about the error and \code{>}
to indicate potential solutions or workarounds that don't require pulling the
data into R. If you have an \code{arrow_not_supported()} error with a \code{>}
suggestion, when the error is ultimately raised by \code{try_error_dplyr()},
\verb{Call collect() first to pull data into R} won't be the only suggestion.

You can still use \code{match.arg()} and \code{assert_that()} for simple input
validation inside of the function bindings. \code{arrow_eval()} will catch their
errors and re-raise them as \code{validation_error}.
}
\keyword{internal}
