/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Objects;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.utils.CompositeAddress;

public class AMQPBridgeSenderInfo {
    private final Role role;
    private final String localAddress;
    private final String localQueue;
    private final String localFqqn;
    private final String remoteAddress;
    private final RoutingType routingType;
    private final String id;

    public AMQPBridgeSenderInfo(Role role, String localAddress, String localQueue, RoutingType routingType, String remoteAddress) {
        this.role = role;
        this.localAddress = localAddress;
        this.localQueue = localQueue;
        this.localFqqn = role == Role.QUEUE_SENDER ? CompositeAddress.toFullyQualified((String)localAddress, (String)localQueue).toString() : null;
        this.routingType = routingType;
        this.remoteAddress = remoteAddress;
        this.id = UUID.randomUUID().toString();
    }

    public String getId() {
        return this.id;
    }

    public Role getRole() {
        return this.role;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getLocalQueue() {
        return this.localQueue;
    }

    public String getLocalFqqn() {
        return this.localFqqn;
    }

    public RoutingType getRoutingType() {
        return this.routingType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.localAddress, this.localFqqn, this.localQueue, this.remoteAddress, this.role, this.routingType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AMQPBridgeSenderInfo)) {
            return false;
        }
        AMQPBridgeSenderInfo other = (AMQPBridgeSenderInfo)obj;
        return Objects.equals(this.localAddress, other.localAddress) && Objects.equals(this.localFqqn, other.localFqqn) && Objects.equals(this.localQueue, other.localQueue) && Objects.equals(this.remoteAddress, other.remoteAddress) && this.role == other.role && this.routingType == other.routingType;
    }

    public String toString() {
        return "AMQPBridgeSenderInfo: { " + String.valueOf((Object)this.getRole()) + ", " + this.getRemoteAddress() + " }";
    }

    static enum Role {
        ADDRESS_SENDER,
        QUEUE_SENDER;

    }
}

