/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueMessageMetrics {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "messageCount");
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> COUNT_UPDATER_PAGED = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "messageCountPaged");
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> DURABLE_COUNT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "durableMessageCount");
    private static final AtomicIntegerFieldUpdater<QueueMessageMetrics> DURABLE_COUNT_UPDATER_PAGED = AtomicIntegerFieldUpdater.newUpdater(QueueMessageMetrics.class, "durableMessageCountPaged");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "persistentSize");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> SIZE_UPDATER_PAGED = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "persistentSizePaged");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> DURABLE_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "durablePersistentSize");
    private static final AtomicLongFieldUpdater<QueueMessageMetrics> DURABLE_SIZE_UPDATER_PAGED = AtomicLongFieldUpdater.newUpdater(QueueMessageMetrics.class, "durablePersistentSizePaged");
    private volatile int messageCount;
    private volatile int messageCountPaged;
    private volatile long persistentSize;
    private volatile long persistentSizePaged;
    private volatile int durableMessageCount;
    private volatile int durableMessageCountPaged;
    private volatile long durablePersistentSize;
    private volatile long durablePersistentSizePaged;
    private final Queue queue;
    private final String name;

    public QueueMessageMetrics(Queue queue, String name) {
        this.queue = Objects.requireNonNull(queue);
        this.name = name;
    }

    public void incrementMetrics(MessageReference reference) {
        long size = QueueMessageMetrics.getPersistentSize(reference);
        if (reference.isPaged()) {
            COUNT_UPDATER_PAGED.incrementAndGet(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} paged messageCountPaged to {}: {}", new Object[]{this, this.messageCountPaged, reference});
            }
            SIZE_UPDATER_PAGED.addAndGet(this, size);
            if (this.queue.isDurable() && reference.isDurable()) {
                DURABLE_COUNT_UPDATER_PAGED.incrementAndGet(this);
                DURABLE_SIZE_UPDATER_PAGED.addAndGet(this, size);
            }
        } else {
            COUNT_UPDATER.incrementAndGet(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} increment messageCount to {}: {}", new Object[]{this, this.messageCount, reference});
            }
            SIZE_UPDATER.addAndGet(this, size);
            if (this.queue.isDurable() && reference.isDurable()) {
                DURABLE_COUNT_UPDATER.incrementAndGet(this);
                DURABLE_SIZE_UPDATER.addAndGet(this, size);
            }
        }
    }

    public void decrementMetrics(MessageReference reference) {
        long size = -QueueMessageMetrics.getPersistentSize(reference);
        if (reference.isPaged()) {
            COUNT_UPDATER_PAGED.decrementAndGet(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} decrement messageCount to {}: {}", new Object[]{this, this.messageCountPaged, reference});
            }
            SIZE_UPDATER_PAGED.addAndGet(this, size);
            if (this.queue.isDurable() && reference.isDurable()) {
                DURABLE_COUNT_UPDATER_PAGED.decrementAndGet(this);
                DURABLE_SIZE_UPDATER_PAGED.addAndGet(this, size);
            }
        } else {
            COUNT_UPDATER.decrementAndGet(this);
            if (logger.isDebugEnabled()) {
                logger.debug("{} decrement messageCount to {}: {}", new Object[]{this, this.messageCount, reference});
            }
            SIZE_UPDATER.addAndGet(this, size);
            if (this.queue.isDurable() && reference.isDurable()) {
                DURABLE_COUNT_UPDATER.decrementAndGet(this);
                DURABLE_SIZE_UPDATER.addAndGet(this, size);
            }
        }
    }

    public int getNonPagedMessageCount() {
        return this.messageCount;
    }

    public int getMessageCount() {
        return this.messageCount + this.messageCountPaged;
    }

    public long getPersistentSize() {
        return this.persistentSize + this.persistentSizePaged;
    }

    public long getNonPagedPersistentSize() {
        return this.persistentSize;
    }

    public long getNonPagedDurablePersistentSize() {
        return this.durablePersistentSize;
    }

    public int getDurableMessageCount() {
        return this.durableMessageCount + this.durableMessageCountPaged;
    }

    public int getNonPagedDurableMessageCount() {
        return this.durableMessageCount;
    }

    public long getDurablePersistentSize() {
        return this.durablePersistentSize + this.durablePersistentSizePaged;
    }

    private static long getPersistentSize(MessageReference reference) {
        long size = 0L;
        try {
            size = reference.getPersistentSize() > 0L ? reference.getPersistentSize() : 0L;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorCalculatePersistentSize(e);
        }
        return size;
    }
}

