/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.restrictor.policy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import org.jolokia.server.core.util.RequestType;

class MBeanPolicyConfig {
    private final Set<ObjectName> patterns = new HashSet<ObjectName>();
    private final Map<ObjectName, Set<String>> readAttributes = new HashMap<ObjectName, Set<String>>();
    private final Map<ObjectName, Set<String>> writeAttributes = new HashMap<ObjectName, Set<String>>();
    private final Map<ObjectName, Set<String>> operations = new HashMap<ObjectName, Set<String>>();

    MBeanPolicyConfig() {
    }

    void addPattern(ObjectName pObjectName) {
        this.patterns.add(pObjectName);
    }

    void addValues(ObjectName pOName, Set<String> pReadAttributes, Set<String> pWriteAttributes, Set<String> pOperations) {
        this.readAttributes.put(pOName, pReadAttributes);
        this.writeAttributes.put(pOName, pWriteAttributes);
        this.operations.put(pOName, pOperations);
        if (pOName.isPattern()) {
            this.addPattern(pOName);
        }
    }

    Set<String> getValues(RequestType pType, ObjectName pName) {
        if (RequestType.READ == pType) {
            return this.readAttributes.get(pName);
        }
        if (RequestType.WRITE == pType) {
            return this.writeAttributes.get(pName);
        }
        if (RequestType.EXEC == pType) {
            return this.operations.get(pName);
        }
        throw new IllegalArgumentException("Invalid type " + String.valueOf((Object)pType));
    }

    ObjectName findMatchingMBeanPattern(ObjectName pName) {
        for (ObjectName pattern : this.patterns) {
            if (!pattern.apply(pName)) continue;
            return pattern;
        }
        return null;
    }
}

