/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.fate.AdminUtil;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.ReadOnlyRepo;
import org.apache.accumulo.core.fate.ReadOnlyTStore;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooCache;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.shell.Shell;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.zookeeper.KeeperException;

public class FateCommand
extends Shell.Command {
    private static final String warning = "WARNING: This command is deprecated for removal. Use 'accumulo admin'\n";
    private Option cancel;
    private Option delete;
    private Option dump;
    private Option fail;
    private Option list;
    private Option print;
    private Option summary;
    private Option secretOption;
    private Option statusOption;
    private Option disablePaginationOpt;

    protected String getZKRoot(ClientContext context) {
        return context.getZooKeeperRoot();
    }

    synchronized ZooReaderWriter getZooReaderWriter(ClientContext context, String secret) {
        if (secret == null) {
            secret = SiteConfiguration.auto().get(Property.INSTANCE_SECRET);
        }
        return context.getZooReader().asWriter(secret);
    }

    protected ZooStore<FateCommand> getZooStore(String fateZkPath, ZooReaderWriter zrw, ZooCache zc) throws KeeperException, InterruptedException {
        return new ZooStore(fateZkPath, zrw, zc);
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws ParseException, KeeperException, InterruptedException, IOException, AccumuloException, AccumuloSecurityException {
        Shell.log.warn(warning);
        ClientContext context = shellState.getContext();
        boolean failedCommand = false;
        AdminUtil admin = new AdminUtil(false);
        String zkRoot = this.getZKRoot(context);
        String fatePath = zkRoot + "/fate";
        ServiceLock.ServiceLockPath managerLockPath = ServiceLock.path((String)(zkRoot + "/managers/lock"));
        ServiceLock.ServiceLockPath tableLocksPath = ServiceLock.path((String)(zkRoot + "/table_locks"));
        ZooReaderWriter zk = this.getZooReaderWriter(context, cl.getOptionValue(this.secretOption.getOpt()));
        ZooStore<FateCommand> zs = this.getZooStore(fatePath, zk, context.getZooCache());
        if (cl.hasOption(this.cancel.getOpt())) {
            CharSequence[] txids = cl.getOptionValues(this.cancel.getOpt());
            this.validateArgs((String[])txids);
            throw new ParseException("Option not available. Use 'accumulo admin fate -c " + String.join((CharSequence)" ", txids) + "'");
        }
        if (cl.hasOption(this.fail.getOpt())) {
            String[] txids = cl.getOptionValues(this.fail.getOpt());
            this.validateArgs(txids);
            failedCommand = this.failTx(shellState.getWriter(), (AdminUtil<FateCommand>)admin, zs, zk, managerLockPath, txids);
        } else if (cl.hasOption(this.delete.getOpt())) {
            String[] txids = cl.getOptionValues(this.delete.getOpt());
            this.validateArgs(txids);
            failedCommand = this.deleteTx(shellState.getWriter(), (AdminUtil<FateCommand>)admin, zs, zk, managerLockPath, txids);
        } else if (cl.hasOption(this.list.getOpt())) {
            this.printTx(shellState, (AdminUtil<FateCommand>)admin, zs, zk, tableLocksPath, cl.getOptionValues(this.list.getOpt()), cl);
        } else if (cl.hasOption(this.print.getOpt())) {
            this.printTx(shellState, (AdminUtil<FateCommand>)admin, zs, zk, tableLocksPath, cl.getOptionValues(this.print.getOpt()), cl);
        } else {
            if (cl.hasOption(this.summary.getOpt())) {
                throw new ParseException("Option not available. Use 'accumulo admin fate --summary'");
            }
            if (cl.hasOption(this.dump.getOpt())) {
                String output = this.dumpTx(zs, cl.getOptionValues(this.dump.getOpt()));
                shellState.getWriter().println(output);
            } else {
                throw new ParseException("Invalid command option");
            }
        }
        return failedCommand ? 1 : 0;
    }

    String dumpTx(ZooStore<FateCommand> zs, String[] args) {
        ArrayList<Long> txids;
        if (args.length == 1) {
            txids = zs.list();
        } else {
            txids = new ArrayList<Long>();
            for (int i = 1; i < args.length; ++i) {
                txids.add(FateTxId.parseTidFromUserInput((String)args[i]));
            }
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(ReadOnlyRepo.class, new InterfaceSerializer()).registerTypeAdapter(Repo.class, new InterfaceSerializer()).registerTypeAdapter(byte[].class, (Object)new ByteArraySerializer()).setPrettyPrinting().create();
        ArrayList<FateStack> txStacks = new ArrayList<FateStack>();
        for (Long txid : txids) {
            List repoStack = zs.getStack(txid.longValue());
            txStacks.add(new FateStack(txid, repoStack));
        }
        return gson.toJson(txStacks);
    }

    protected void printTx(Shell shellState, AdminUtil<FateCommand> admin, ZooStore<FateCommand> zs, ZooReaderWriter zk, ServiceLock.ServiceLockPath tableLocksPath, String[] args, CommandLine cl) throws InterruptedException, KeeperException, IOException {
        HashSet<Long> filterTxid = new HashSet<Long>();
        if (args != null && args.length >= 1) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].isEmpty()) continue;
                Long val = FateTxId.parseTidFromUserInput((String)args[i]);
                filterTxid.add(val);
            }
        }
        EnumSet<ReadOnlyTStore.TStatus> statusFilter = this.getCmdLineStatusFilters(cl);
        StringBuilder buf = new StringBuilder(8096);
        Formatter fmt = new Formatter(buf);
        admin.print(zs, (ZooReader)zk, tableLocksPath, fmt, filterTxid, statusFilter);
        shellState.printLines(Collections.singletonList(buf.toString()).iterator(), !cl.hasOption(this.disablePaginationOpt.getOpt()));
    }

    protected boolean deleteTx(PrintWriter out, AdminUtil<FateCommand> admin, ZooStore<FateCommand> zs, ZooReaderWriter zk, ServiceLock.ServiceLockPath zLockManagerPath, String[] args) throws InterruptedException, KeeperException {
        for (int i = 1; i < args.length; ++i) {
            if (!admin.prepDelete(zs, zk, zLockManagerPath, args[i])) {
                out.printf("Could not delete transaction: %s%n", args[i]);
                return false;
            }
            admin.deleteLocks(zk, zLockManagerPath, args[i]);
        }
        return true;
    }

    private void validateArgs(String[] args) throws ParseException {
        if (args.length < 1) {
            throw new ParseException("Must provide transaction ID");
        }
    }

    public boolean failTx(PrintWriter out, AdminUtil<FateCommand> admin, ZooStore<FateCommand> zs, ZooReaderWriter zk, ServiceLock.ServiceLockPath managerLockPath, String[] args) {
        boolean success = true;
        for (int i = 1; i < args.length; ++i) {
            if (admin.prepFail(zs, zk, managerLockPath, args[i])) continue;
            out.printf("Could not fail transaction: %s%n", args[i]);
            return !success;
        }
        return success;
    }

    @Override
    public String description() {
        return "manage FATE transactions";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup commands = new OptionGroup();
        this.cancel = new Option("cancel", "cancel-submitted", true, "cancel new or submitted FaTE transactions");
        this.cancel.setArgName("txid");
        this.cancel.setArgs(-2);
        this.cancel.setOptionalArg(false);
        this.fail = new Option("fail", "fail", true, "Transition FaTE transaction status to FAILED_IN_PROGRESS (requires Manager to be down)");
        this.fail.setArgName("txid");
        this.fail.setArgs(-2);
        this.fail.setOptionalArg(false);
        this.delete = new Option("delete", "delete", true, "delete locks associated with FaTE transactions (requires Manager to be down)");
        this.delete.setArgName("txid");
        this.delete.setArgs(-2);
        this.delete.setOptionalArg(false);
        this.list = new Option("list", "list", true, "print FaTE transaction information. Filter on id(s) with FATE[id] or id list ");
        this.list.setArgName("txid");
        this.list.setArgs(-2);
        this.list.setOptionalArg(true);
        this.print = new Option("print", "print", true, "print FaTE transaction information. Filter on id(s) with FATE[id] or id list ");
        this.print.setArgName("txid");
        this.print.setArgs(-2);
        this.print.setOptionalArg(true);
        this.summary = new Option("summary", "summary", true, "print a summary of FaTE transaction information");
        this.summary.setArgName("--json");
        this.summary.setOptionalArg(true);
        this.dump = new Option("dump", "dump", true, "dump FaTE transaction information details");
        this.dump.setArgName("txid");
        this.dump.setArgs(-2);
        this.dump.setOptionalArg(true);
        commands.addOption(this.cancel);
        commands.addOption(this.fail);
        commands.addOption(this.delete);
        commands.addOption(this.list);
        commands.addOption(this.print);
        commands.addOption(this.summary);
        commands.addOption(this.dump);
        o.addOptionGroup(commands);
        this.secretOption = new Option("s", "secret", true, "specify the instance secret to use");
        this.secretOption.setOptionalArg(false);
        o.addOption(this.secretOption);
        this.statusOption = new Option("t", "status-type", true, "filter 'print' on the transaction status type(s) {NEW, SUBMITTED, IN_PROGRESS, FAILED_IN_PROGRESS, FAILED, SUCCESSFUL}");
        this.statusOption.setArgs(-2);
        this.statusOption.setOptionalArg(false);
        o.addOption(this.statusOption);
        this.disablePaginationOpt = new Option("np", "no-pagination", false, "disables pagination of output");
        o.addOption(this.disablePaginationOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return -1;
    }

    @Override
    public String usage() {
        String msg = super.usage();
        return warning + msg;
    }

    private EnumSet<ReadOnlyTStore.TStatus> getCmdLineStatusFilters(CommandLine cl) {
        EnumSet<ReadOnlyTStore.TStatus> statusFilter = null;
        if (cl.hasOption(this.statusOption.getOpt())) {
            String[] tstat;
            statusFilter = EnumSet.noneOf(ReadOnlyTStore.TStatus.class);
            for (String element : tstat = cl.getOptionValues(this.statusOption.getOpt())) {
                statusFilter.add(ReadOnlyTStore.TStatus.valueOf((String)element));
            }
        }
        return statusFilter;
    }

    private static class InterfaceSerializer<T>
    implements JsonSerializer<T> {
        private InterfaceSerializer() {
        }

        public JsonElement serialize(T link, Type type, JsonSerializationContext context) {
            JsonElement je = context.serialize(link, link.getClass());
            JsonObject jo = new JsonObject();
            jo.add(link.getClass().getName(), je);
            return jo;
        }
    }

    private static class ByteArraySerializer
    implements JsonSerializer<byte[]> {
        private ByteArraySerializer() {
        }

        public JsonElement serialize(byte[] link, Type type, JsonSerializationContext context) {
            return context.serialize((Object)new ByteArrayContainer(link));
        }
    }

    public static class FateStack {
        String txIdString;
        List<ReadOnlyRepo<FateCommand>> stack;

        FateStack(Long txid, List<ReadOnlyRepo<FateCommand>> stack) {
            this.txIdString = FastFormat.toHexString((long)txid);
            this.stack = stack;
        }
    }

    public static class ByteArrayContainer {
        public String asUtf8;
        public String asBase64;

        ByteArrayContainer(byte[] ba) {
            this.asUtf8 = new String(ba, StandardCharsets.UTF_8);
            this.asBase64 = Base64.getUrlEncoder().encodeToString(ba);
        }
    }
}

