/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class DropUserCommand
extends Shell.Command {
    private Option forceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException {
        String user = cl.getArgs()[0];
        if (shellState.getAccumuloClient().whoami().equals(user)) {
            throw new BadArgumentException("You cannot delete yourself", fullCommand, fullCommand.indexOf(user));
        }
        this.doDropUser(shellState, user, cl.hasOption(this.forceOpt.getOpt()));
        return 0;
    }

    private void doDropUser(Shell shellState, String user, boolean force) throws AccumuloException, AccumuloSecurityException {
        if (force || shellState.confirm(this.getName() + " { " + user + " }").orElse(false).booleanValue()) {
            shellState.getAccumuloClient().securityOperations().dropLocalUser(user);
            Shell.log.debug("Deleted user {}", (Object)user);
        }
    }

    @Override
    public String description() {
        return "deletes a user";
    }

    @Override
    public String usage() {
        return this.getName() + " <username>";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForUsers(root, completionSet);
    }

    @Override
    public int numArgs() {
        return 1;
    }

    @Override
    public Options getOptions() {
        this.forceOpt = new Option("f", "force", false, "force deletion without prompting");
        Options opts = super.getOptions();
        opts.addOption(this.forceOpt);
        return opts;
    }
}

