/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.constraints.VisibilityConstraint;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iteratorsImpl.IteratorConfigUtil;
import org.apache.accumulo.core.util.Validators;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.ShellUtil;
import org.apache.accumulo.shell.Token;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class CreateTableCommand
extends Shell.Command {
    private Option createTableOptCopySplits;
    private Option createTableOptCopyConfig;
    private Option createTableOptExcludeParentProps;
    private Option createTableOptSplit;
    private Option createTableOptTimeLogical;
    private Option createTableOptTimeMillis;
    private Option createTableNoDefaultIters;
    private Option createTableOptEVC;
    private Option base64Opt;
    private Option createTableOptFormatter;
    private Option createTableOptInitProp;
    private Option createTableOptLocalityProps;
    private Option createTableOptIteratorProps;
    private Option createTableOptOffline;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, IOException, NamespaceNotFoundException {
        String oldTable;
        String tableName = cl.getArgs()[0];
        NewTableConfiguration ntc = new NewTableConfiguration();
        Validators.NEW_TABLE_NAME.validate((Object)tableName);
        if (shellState.getAccumuloClient().tableOperations().exists(tableName)) {
            throw new TableExistsException(null, tableName, null);
        }
        boolean decode = cl.hasOption(this.base64Opt.getOpt());
        if (cl.hasOption(this.createTableOptSplit.getOpt())) {
            ntc.withSplits(new TreeSet<Text>(ShellUtil.scanFile(cl.getOptionValue(this.createTableOptSplit.getOpt()), decode)));
        } else if (cl.hasOption(this.createTableOptCopySplits.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopySplits.getOpt());
            if (!shellState.getAccumuloClient().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
            ntc.withSplits(new TreeSet(shellState.getAccumuloClient().tableOperations().listSplits(oldTable)));
        }
        if (cl.hasOption(this.createTableOptExcludeParentProps.getLongOpt()) && !cl.hasOption(this.createTableOptCopyConfig.getOpt())) {
            throw new IllegalArgumentException(this.createTableOptExcludeParentProps.getLongOpt() + " only valid when using " + this.createTableOptCopyConfig.getLongOpt());
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt())) {
            oldTable = cl.getOptionValue(this.createTableOptCopyConfig.getOpt());
            if (!shellState.getAccumuloClient().tableOperations().exists(oldTable)) {
                throw new TableNotFoundException(null, oldTable, null);
            }
        }
        TimeType timeType = TimeType.MILLIS;
        if (cl.hasOption(this.createTableOptTimeLogical.getOpt())) {
            timeType = TimeType.LOGICAL;
        }
        HashMap<String, String> initProperties = new HashMap<String, String>(ShellUtil.parseMapOpt(cl, this.createTableOptInitProp));
        if (cl.hasOption(this.createTableOptIteratorProps.getOpt())) {
            this.attachIteratorToNewTable(cl, shellState, ntc);
        }
        if (cl.hasOption(this.createTableOptLocalityProps.getOpt())) {
            this.setLocalityForNewTable(cl, ntc);
        }
        if (cl.hasOption(this.createTableOptOffline.getOpt())) {
            ntc.createOffline();
        }
        if (cl.hasOption(this.createTableOptCopyConfig.getOpt())) {
            String srcTable = cl.getOptionValue(this.createTableOptCopyConfig.getOpt());
            if (cl.hasOption(this.createTableOptExcludeParentProps.getLongOpt())) {
                Map tableProps = shellState.getAccumuloClient().tableOperations().getTableProperties(srcTable);
                tableProps.entrySet().stream().filter(entry -> Property.isValidTablePropertyKey((String)((String)entry.getKey()))).forEach(entry -> initProperties.put((String)entry.getKey(), (String)entry.getValue()));
            } else {
                Map configuration = shellState.getAccumuloClient().tableOperations().getConfiguration(srcTable);
                configuration.entrySet().stream().filter(entry -> Property.isValidTablePropertyKey((String)((String)entry.getKey()))).forEach(entry -> initProperties.put((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        if (cl.hasOption(this.createTableNoDefaultIters.getOpt())) {
            Set initialProps = IteratorConfigUtil.generateInitialTableProperties((boolean)true).keySet();
            initialProps.forEach(initProperties::remove);
        }
        if (cl.hasOption(this.createTableOptFormatter.getOpt())) {
            String formatterClass = cl.getOptionValue(this.createTableOptFormatter.getOpt());
            initProperties.put(Property.TABLE_FORMATTER_CLASS.toString(), formatterClass);
        }
        shellState.getAccumuloClient().tableOperations().create(tableName, ntc.setTimeType(timeType).setProperties(initProperties));
        shellState.setTableName(tableName);
        if (cl.hasOption(this.createTableOptEVC.getOpt())) {
            try {
                shellState.getAccumuloClient().tableOperations().addConstraint(tableName, VisibilityConstraint.class.getName());
            }
            catch (AccumuloException e) {
                Shell.log.warn("{} while setting visibility constraint, but table was created", (Object)e.getMessage(), (Object)e);
            }
        }
        return 0;
    }

    private void setLocalityForNewTable(CommandLine cl, NewTableConfiguration ntc) {
        String[] options;
        HashMap localityGroupMap = new HashMap();
        for (String localityInfo : options = cl.getOptionValues(this.createTableOptLocalityProps.getOpt())) {
            String[] parts = localityInfo.split("=", 2);
            if (parts.length < 2) {
                throw new IllegalArgumentException("Missing '=' or there are spaces between entries");
            }
            String groupName = parts[0];
            HashSet<Text> colFams = new HashSet<Text>();
            for (String family : parts[1].split(",")) {
                colFams.add(new Text(family.getBytes(Shell.CHARSET)));
            }
            if (localityGroupMap.put(groupName, colFams) == null) continue;
            throw new IllegalArgumentException("Duplicate locality group name found. Group names must be unique");
        }
        ntc.setLocalityGroups(localityGroupMap);
    }

    private void attachIteratorToNewTable(CommandLine cl, Shell shellState, NewTableConfiguration ntc) {
        String[] options;
        if (shellState.iteratorProfiles.isEmpty()) {
            throw new IllegalArgumentException("No shell iterator profiles have been created.");
        }
        for (String profileInfo : options = cl.getOptionValues(this.createTableOptIteratorProps.getOpt())) {
            EnumSet<IteratorUtil.IteratorScope> scopeEnumSet;
            IteratorSetting iteratorSetting;
            String[] parts = profileInfo.split(":", 2);
            String profileName = parts[0];
            try {
                iteratorSetting = shellState.iteratorProfiles.get(profileName).get(0);
            }
            catch (NullPointerException ex) {
                throw new IllegalArgumentException("invalid iterator argument. Either profile does not exist or unexpected spaces in argument list.", ex);
            }
            if (parts.length == 1) {
                scopeEnumSet = EnumSet.allOf(IteratorUtil.IteratorScope.class);
            } else {
                List<String> scopeArgs = Arrays.asList(parts[1].split(","));
                if (scopeArgs.size() > 3) {
                    throw new IllegalArgumentException("Too many scope arguments supplied");
                }
                if (scopeArgs.contains("all")) {
                    if (scopeArgs.size() > 1) {
                        throw new IllegalArgumentException("Cannot use 'all' in conjunction with other scopes");
                    }
                    scopeEnumSet = EnumSet.allOf(IteratorUtil.IteratorScope.class);
                } else {
                    scopeEnumSet = this.validateScopes(scopeArgs);
                }
            }
            ntc.attachIterator(iteratorSetting, scopeEnumSet);
        }
    }

    private EnumSet<IteratorUtil.IteratorScope> validateScopes(List<String> scopeList) {
        EnumSet<IteratorUtil.IteratorScope> scopes = EnumSet.noneOf(IteratorUtil.IteratorScope.class);
        for (String scopeStr : scopeList) {
            try {
                IteratorUtil.IteratorScope scope = IteratorUtil.IteratorScope.valueOf((String)scopeStr);
                if (scopes.add(scope)) continue;
                throw new IllegalArgumentException("duplicate scope arguments found");
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("illegal scope arguments: " + ex.getMessage(), ex);
            }
        }
        return scopes;
    }

    @Override
    public String description() {
        return "creates a new table, with optional aggregators, iterators, locality groups and optionally pre-split";
    }

    @Override
    public String usage() {
        return this.getName() + " <tableName>";
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.createTableOptCopyConfig = new Option("cc", "copy-config", true, "table to copy effective configuration from");
        this.createTableOptExcludeParentProps = new Option(null, "exclude-parent-properties", false, "exclude properties from its parent(s) when copying configuration");
        this.createTableOptCopySplits = new Option("cs", "copy-splits", true, "table to copy current splits from");
        this.createTableOptSplit = new Option("sf", "splits-file", true, "file with a newline-separated list of rows to split the table with");
        this.createTableOptTimeLogical = new Option("tl", "time-logical", false, "use logical time");
        this.createTableOptTimeMillis = new Option("tm", "time-millis", false, "use time in milliseconds");
        this.createTableNoDefaultIters = new Option("ndi", "no-default-iterators", false, "prevent creation of the normal default iterator set");
        this.createTableOptEVC = new Option("evc", "enable-visibility-constraint", false, "prevent users from writing data they cannot read. When enabling this, consider disabling bulk import and alter table.");
        this.createTableOptFormatter = new Option("f", "formatter", true, "default formatter to set");
        this.createTableOptInitProp = new Option("prop", "init-properties", true, "user defined initial properties");
        this.createTableOptCopyConfig.setArgName("table");
        this.createTableOptCopySplits.setArgName("table");
        this.createTableOptSplit.setArgName("filename");
        this.createTableOptFormatter.setArgName("className");
        this.createTableOptInitProp.setArgName("properties");
        this.createTableOptLocalityProps = new Option("l", "locality", true, "create locality groups at table creation");
        this.createTableOptLocalityProps.setArgName("group=col_fam[,col_fam]");
        this.createTableOptLocalityProps.setArgs(-2);
        this.createTableOptIteratorProps = new Option("i", "iter", true, "initialize iterator at table creation using profile. If no scope supplied, all scopes are activated.");
        this.createTableOptIteratorProps.setArgName("profile[:[all]|[scan[,]][minc[,]][majc]]");
        this.createTableOptIteratorProps.setArgs(-2);
        this.createTableOptOffline = new Option("o", "offline", false, "create table in offline mode");
        OptionGroup splitOrCopySplit = new OptionGroup();
        splitOrCopySplit.addOption(this.createTableOptSplit);
        splitOrCopySplit.addOption(this.createTableOptCopySplits);
        OptionGroup timeGroup = new OptionGroup();
        timeGroup.addOption(this.createTableOptTimeLogical);
        timeGroup.addOption(this.createTableOptTimeMillis);
        this.base64Opt = new Option("b64", "base64encoded", false, "decode encoded split points");
        o.addOption(this.base64Opt);
        o.addOptionGroup(splitOrCopySplit);
        o.addOptionGroup(timeGroup);
        o.addOption(this.createTableOptSplit);
        o.addOption(this.createTableOptCopyConfig);
        o.addOption(this.createTableOptExcludeParentProps);
        o.addOption(this.createTableNoDefaultIters);
        o.addOption(this.createTableOptEVC);
        o.addOption(this.createTableOptFormatter);
        o.addOption(this.createTableOptInitProp);
        o.addOption(this.createTableOptLocalityProps);
        o.addOption(this.createTableOptIteratorProps);
        o.addOption(this.createTableOptOffline);
        return o;
    }

    @Override
    public int numArgs() {
        return 1;
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> special) {
        this.registerCompletionForNamespaces(root, special);
    }
}

