/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.ratelimit;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.accumulo.core.util.ratelimit.GuavaRateLimiter;
import org.apache.accumulo.core.util.ratelimit.RateLimiter;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedRateLimiterFactory {
    private static final long REPORT_RATE = 60000L;
    private static final long UPDATE_RATE = 1000L;
    private static SharedRateLimiterFactory instance = null;
    private static ScheduledFuture<?> updateTaskFuture;
    private final Logger log = LoggerFactory.getLogger(SharedRateLimiterFactory.class);
    private final WeakHashMap<String, WeakReference<SharedRateLimiter>> activeLimiters = new WeakHashMap();

    private SharedRateLimiterFactory() {
    }

    public static synchronized SharedRateLimiterFactory getInstance(ScheduledThreadPoolExecutor executor) {
        if (instance == null) {
            instance = new SharedRateLimiterFactory();
            updateTaskFuture = executor.scheduleWithFixedDelay(Threads.createNamedRunnable("SharedRateLimiterFactory update polling", instance::updateAll), 1000L, 1000L, TimeUnit.MILLISECONDS);
            ScheduledFuture<?> future = executor.scheduleWithFixedDelay(Threads.createNamedRunnable("SharedRateLimiterFactory report polling", instance::reportAll), 60000L, 60000L, TimeUnit.MILLISECONDS);
            ThreadPools.watchNonCriticalScheduledTask(future);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RateLimiter create(String name, RateProvider rateProvider) {
        WeakHashMap<String, WeakReference<SharedRateLimiter>> weakHashMap = this.activeLimiters;
        synchronized (weakHashMap) {
            WeakReference<SharedRateLimiter> limiterRef;
            SharedRateLimiter limiter;
            if (updateTaskFuture.isDone()) {
                this.log.warn("SharedRateLimiterFactory update task has failed.");
            }
            SharedRateLimiter sharedRateLimiter = limiter = (limiterRef = this.activeLimiters.get(name)) == null ? null : (SharedRateLimiter)limiterRef.get();
            if (limiter == null) {
                limiter = new SharedRateLimiter(name, rateProvider, rateProvider.getDesiredRate());
                this.activeLimiters.put(name, new WeakReference<SharedRateLimiter>(limiter));
            }
            return limiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAndThen(String actionName, Consumer<SharedRateLimiter> action) {
        HashMap<String, SharedRateLimiter> limitersCopy = new HashMap<String, SharedRateLimiter>();
        WeakHashMap<String, WeakReference<SharedRateLimiter>> weakHashMap = this.activeLimiters;
        synchronized (weakHashMap) {
            this.activeLimiters.forEach((name, limiterRef) -> {
                SharedRateLimiter limiter = (SharedRateLimiter)limiterRef.get();
                if (limiter != null) {
                    limitersCopy.put((String)name, limiter);
                }
            });
        }
        limitersCopy.forEach((name, limiter) -> {
            try {
                action.accept((SharedRateLimiter)limiter);
            }
            catch (RuntimeException e) {
                this.log.error("Failed to {} limiter {}", new Object[]{actionName, name, e});
            }
        });
    }

    private void updateAll() {
        this.copyAndThen("update", SharedRateLimiter::update);
    }

    private void reportAll() {
        this.copyAndThen("report", SharedRateLimiter::report);
    }

    protected class SharedRateLimiter
    extends GuavaRateLimiter {
        private final AtomicLong permitsAcquired;
        private final AtomicLong lastUpdate;
        private final RateProvider rateProvider;
        private final String name;

        SharedRateLimiter(String name, RateProvider rateProvider, long initialRate) {
            super(initialRate);
            this.permitsAcquired = new AtomicLong();
            this.lastUpdate = new AtomicLong();
            this.name = name;
            this.rateProvider = rateProvider;
            this.lastUpdate.set(System.nanoTime());
        }

        @Override
        public void acquire(long numPermits) {
            super.acquire(numPermits);
            this.permitsAcquired.addAndGet(numPermits);
        }

        public void update() {
            long rate = this.rateProvider.getDesiredRate();
            if (rate != this.getRate()) {
                this.setRate(rate);
            }
        }

        public void report() {
            if (SharedRateLimiterFactory.this.log.isDebugEnabled()) {
                long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastUpdate.get());
                if (duration == 0L) {
                    return;
                }
                this.lastUpdate.set(System.nanoTime());
                long sum = this.permitsAcquired.get();
                this.permitsAcquired.set(0L);
                if (sum > 0L) {
                    SharedRateLimiterFactory.this.log.debug(String.format("RateLimiter '%s': %,d of %,d permits/second", this.name, sum * 1000L / duration, this.getRate()));
                }
            }
        }
    }

    public static interface RateProvider {
        public long getDesiredRate();
    }
}

