/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.accumulo.core.util.format.DateFormatSupplier;

public class FormatterConfig {
    private boolean printTimestamps;
    private int shownLength;
    private Supplier<DateFormat> dateFormatSupplier;

    public FormatterConfig() {
        this.setPrintTimestamps(false);
        this.doNotLimitShowLength();
        this.dateFormatSupplier = DateFormatSupplier.createDefaultFormatSupplier();
    }

    public FormatterConfig(FormatterConfig other) {
        this.printTimestamps = other.printTimestamps;
        this.shownLength = other.shownLength;
        this.dateFormatSupplier = other.dateFormatSupplier;
    }

    public boolean willPrintTimestamps() {
        return this.printTimestamps;
    }

    public FormatterConfig setPrintTimestamps(boolean printTimestamps) {
        this.printTimestamps = printTimestamps;
        return this;
    }

    public int getShownLength() {
        return this.shownLength;
    }

    public boolean willLimitShowLength() {
        return this.shownLength != Integer.MAX_VALUE;
    }

    public FormatterConfig setShownLength(int shownLength) {
        Preconditions.checkArgument((shownLength >= 0 ? 1 : 0) != 0, (Object)"Shown length cannot be negative");
        this.shownLength = shownLength;
        return this;
    }

    public FormatterConfig doNotLimitShowLength() {
        this.shownLength = Integer.MAX_VALUE;
        return this;
    }

    public Supplier<DateFormat> getDateFormatSupplier() {
        return this.dateFormatSupplier;
    }

    public FormatterConfig setDateFormatSupplier(Supplier<DateFormat> dateFormatSupplier) {
        this.dateFormatSupplier = dateFormatSupplier;
        return this;
    }

    public static class DefaultDateFormat
    extends SimpleDateFormat {
        private static final long serialVersionUID = 1L;

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            toAppendTo.append(date.getTime());
            return toAppendTo;
        }

        @Override
        public Date parse(String source, ParsePosition pos) {
            return new Date(Long.parseLong(source));
        }
    }
}

