/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.compaction;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.spi.compaction.CompactionExecutorId;
import org.apache.accumulo.core.spi.compaction.CompactionServiceId;

public class CompactionExecutorIdImpl
extends CompactionExecutorId {
    private static final long serialVersionUID = 1L;

    protected CompactionExecutorIdImpl(String canonical) {
        super(canonical);
    }

    public boolean isExternalId() {
        return this.canonical().startsWith("e.");
    }

    public String getExternalName() {
        Preconditions.checkState((boolean)this.isExternalId());
        return this.canonical().substring("e.".length());
    }

    public static CompactionExecutorId internalId(CompactionServiceId csid, String executorName) {
        return new CompactionExecutorIdImpl("i." + String.valueOf(csid) + "." + executorName);
    }

    public static CompactionExecutorId externalId(String executorName) {
        return new CompactionExecutorIdImpl("e." + executorName);
    }
}

