/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.singletons;

import java.lang.ref.Cleaner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.singletons.SingletonManager;
import org.apache.accumulo.core.util.cleaner.CleanerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonReservation
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(SingletonReservation.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Cleaner.Cleanable cleanable = CleanerUtil.unclosed(this, AccumuloClient.class, this.closed, log, null);
    private static final SingletonReservation NOOP = new NoopSingletonReservation();

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanable.clean();
            SingletonManager.releaseReservation();
        }
    }

    public static SingletonReservation noop() {
        return NOOP;
    }

    private static class NoopSingletonReservation
    extends SingletonReservation {
        NoopSingletonReservation() {
            this.closed.set(true);
            this.cleanable.clean();
        }
    }
}

