/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc.clients;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationCoordinatorThriftClient
extends ThriftClientTypes<ReplicationCoordinator.Client> {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicationCoordinatorThriftClient.class);

    ReplicationCoordinatorThriftClient(String serviceName) {
        super(serviceName, new ReplicationCoordinator.Client.Factory());
    }

    @Override
    public ReplicationCoordinator.Client getConnection(ClientContext context) {
        String replCoordinatorAddr;
        List<String> locations = context.getManagerLocations();
        if (locations.isEmpty()) {
            LOG.debug("No managers for replication to instance {}", (Object)context.getInstanceName());
            return null;
        }
        String managerThriftService = locations.get(0);
        if (managerThriftService.endsWith(":0")) {
            LOG.warn("Manager found for {} did not have real location {}", (Object)context.getInstanceName(), (Object)managerThriftService);
            return null;
        }
        String zkPath = context.getZooKeeperRoot() + "/managers/repl_coord_addr";
        LOG.debug("Using ZooKeeper quorum at {} with path {} to find peer Manager information", (Object)context.getZooKeepers(), (Object)zkPath);
        try {
            ZooReader reader = context.getZooReader();
            replCoordinatorAddr = new String(reader.getData(zkPath), StandardCharsets.UTF_8);
        }
        catch (InterruptedException | KeeperException e) {
            LOG.error("Could not fetch remote coordinator port", e);
            return null;
        }
        HostAndPort coordinatorAddr = HostAndPort.fromString(replCoordinatorAddr);
        LOG.debug("Connecting to manager at {}", (Object)coordinatorAddr);
        try {
            return ThriftUtil.getClientNoTimeout(ThriftClientTypes.REPLICATION_COORDINATOR, coordinatorAddr, context);
        }
        catch (TTransportException tte) {
            LOG.debug("Failed to connect to manager coordinator service ({})", (Object)coordinatorAddr, (Object)tte);
            return null;
        }
    }

    @Override
    public ReplicationCoordinator.Client getConnectionWithRetry(ClientContext context) {
        Objects.requireNonNull(context);
        for (int attempts = 1; attempts <= 10; ++attempts) {
            ReplicationCoordinator.Client result = this.getConnection(context);
            if (result != null) {
                return result;
            }
            LOG.debug("Could not get ReplicationCoordinator connection to {}, will retry", (Object)context.getInstanceName());
            try {
                Thread.sleep((long)attempts * 250L);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Timed out trying to communicate with manager from " + context.getInstanceName());
    }

    @Override
    public <R> R execute(ClientContext context, ThriftClientTypes.Exec<R, ReplicationCoordinator.Client> exec) throws AccumuloException, AccumuloSecurityException {
        ReplicationCoordinator.Client client = null;
        for (int i = 0; i < 10; ++i) {
            try {
                client = this.getConnectionWithRetry(context);
                R r = exec.execute(client);
                return r;
            }
            catch (TTransportException tte) {
                LOG.debug("ReplicationClient coordinator request failed, retrying ... ", (Throwable)tte);
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new AccumuloException(e);
                }
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)((Object)e));
            }
            catch (Exception e) {
                throw new AccumuloException(e);
            }
            finally {
                if (client != null) {
                    ThriftUtil.close(client, context);
                }
            }
        }
        throw new AccumuloException("Could not connect to ReplicationCoordinator at " + context.getInstanceName());
    }
}

