/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.summary;

import java.util.Map;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;

public class Summary {
    private final Map<String, Long> statistics;
    private final SummarizerConfiguration config;
    private final FileStatistics fileStats;

    public Summary(Map<String, Long> summary, SummarizerConfiguration config, long totalFiles, long filesMissingSummary, long filesWithExtra, long filesWithLarge, long deletedFiles) {
        this.statistics = Map.copyOf(summary);
        this.config = config;
        this.fileStats = new FileStatistics(totalFiles, filesMissingSummary, filesWithExtra, filesWithLarge, deletedFiles);
    }

    public FileStatistics getFileStatistics() {
        return this.fileStats;
    }

    public SummarizerConfiguration getSummarizerConfiguration() {
        return this.config;
    }

    public Map<String, Long> getStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "config : " + String.valueOf(this.config) + " filestats : " + String.valueOf(this.fileStats) + " statistics : " + String.valueOf(this.statistics);
    }

    public static class FileStatistics {
        private final long total;
        private final long missing;
        private final long extra;
        private final long large;
        private final long deleted;

        private FileStatistics(long total, long missing, long extra, long large, long deleted) {
            this.total = total;
            this.missing = missing;
            this.extra = extra;
            this.large = large;
            this.deleted = deleted;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMissing() {
            return this.missing;
        }

        public long getExtra() {
            return this.extra;
        }

        public long getLarge() {
            return this.large;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public long getInaccurate() {
            return this.getMissing() + this.getExtra() + this.getLarge() + this.getDeleted();
        }

        public String toString() {
            return String.format("[total:%,d, missing:%,d, extra:%,d, large:%,d, deleted:%,d]", this.total, this.missing, this.extra, this.large, this.deleted);
        }
    }
}

