/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DelegationTokenConfig {
    private long lifetime = 0L;

    public DelegationTokenConfig setTokenLifetime(long lifetime, TimeUnit unit) {
        Preconditions.checkArgument((lifetime >= 0L ? 1 : 0) != 0, (Object)"Lifetime must be non-negative");
        Objects.requireNonNull(unit, "TimeUnit was null");
        this.lifetime = TimeUnit.MILLISECONDS.convert(lifetime, unit);
        return this;
    }

    public long getTokenLifetime(TimeUnit unit) {
        Objects.requireNonNull(unit);
        return unit.convert(this.lifetime, TimeUnit.MILLISECONDS);
    }

    public boolean equals(Object o) {
        if (o instanceof DelegationTokenConfig) {
            DelegationTokenConfig other = (DelegationTokenConfig)o;
            return this.lifetime == other.lifetime;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.lifetime).hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("DelegationTokenConfig[lifetime=").append(this.lifetime).append("ms]");
        return sb.toString();
    }
}

