/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.accumulo.core.clientImpl.thrift.ThriftNotActiveServiceException;
import org.apache.accumulo.server.HighlyAvailableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlyAvailableServiceInvocationHandler<I>
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HighlyAvailableServiceInvocationHandler.class);
    private final I instance;
    private final HighlyAvailableService service;

    public HighlyAvailableServiceInvocationHandler(I instance, HighlyAvailableService service) {
        this.instance = Objects.requireNonNull(instance);
        this.service = Objects.requireNonNull(service);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.service.isUpgrading()) {
            LOG.trace("Service can not be accessed while it is upgrading.");
            throw new ThriftNotActiveServiceException(this.service.getServiceName(), "Service can not be accessed while it is upgrading");
        }
        if (!this.service.isActiveService()) {
            LOG.trace("Denying access to RPC service as this instance is not the active instance.");
            throw new ThriftNotActiveServiceException(this.service.getServiceName(), "Denying access to RPC service as this instance is not the active instance");
        }
        try {
            return method.invoke(this.instance, args);
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
    }
}

