/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.rpc;

import java.lang.reflect.Field;
import java.net.Socket;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.TThreadedSelectorServer;
import org.apache.thrift.transport.TNonblockingSocket;
import org.apache.thrift.transport.TNonblockingTransport;
import org.slf4j.LoggerFactory;

public class CustomThreadedSelectorServer
extends TThreadedSelectorServer {
    private final Field fbTansportField;

    public CustomThreadedSelectorServer(TThreadedSelectorServer.Args args) {
        super(args);
        try {
            this.fbTansportField = AbstractNonblockingServer.FrameBuffer.class.getDeclaredField("trans_");
            this.fbTansportField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Failed to access required field in Thrift code.", e);
        }
    }

    private TNonblockingTransport getTransport(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        try {
            return (TNonblockingTransport)this.fbTansportField.get(frameBuffer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected Runnable getRunnable(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        return () -> {
            try {
                TNonblockingTransport transport = this.getTransport(frameBuffer);
                if (transport instanceof TNonblockingSocket) {
                    TNonblockingSocket tsock = (TNonblockingSocket)transport;
                    Socket sock = tsock.getSocketChannel().socket();
                    TServerUtils.clientAddress.set(sock.getInetAddress().getHostAddress() + ":" + sock.getPort());
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger(CustomThreadedSelectorServer.class).warn("Failed to get client address ", (Throwable)e);
            }
            frameBuffer.invoke();
        };
    }
}

