/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.classloader.ClassLoaderUtil;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2.1.0")
public class TableLoadBalancer
extends TabletBalancer {
    private static final Logger log = LoggerFactory.getLogger(TableLoadBalancer.class);
    Map<TableId, TabletBalancer> perTableBalancers = new HashMap<TableId, TabletBalancer>();
    private TableOperations tops = null;

    public TableLoadBalancer() {
        log.warn("{} has been deprecated and will be removed in a future release. Please update your configuration to use the equivalent {} instead.", (Object)this.getClass().getName(), (Object)org.apache.accumulo.core.spi.balancer.TableLoadBalancer.class.getName());
    }

    private TabletBalancer constructNewBalancerForTable(String clazzName, TableId tableId) throws Exception {
        String context = null;
        context = ClassLoaderUtil.tableContext((AccumuloConfiguration)this.context.getTableConfiguration(tableId));
        Class clazz = ClassLoaderUtil.loadClass((String)context, (String)clazzName, TabletBalancer.class);
        Constructor constructor = clazz.getConstructor(TableId.class);
        return (TabletBalancer)constructor.newInstance(tableId);
    }

    protected String getLoadBalancerClassNameForTable(TableId table) {
        TableState tableState = this.context.getTableManager().getTableState(table);
        if (tableState == TableState.ONLINE) {
            return this.context.getTableConfiguration(table).get(Property.TABLE_LOAD_BALANCER);
        }
        return null;
    }

    protected TabletBalancer getBalancerForTable(TableId tableId) {
        TabletBalancer balancer = this.perTableBalancers.get(tableId);
        String clazzName = this.getLoadBalancerClassNameForTable(tableId);
        if (clazzName == null) {
            clazzName = DefaultLoadBalancer.class.getName();
        }
        if (balancer != null && !clazzName.equals(balancer.getClass().getName())) {
            try {
                TabletBalancer newBalancer = this.constructNewBalancerForTable(clazzName, tableId);
                if (newBalancer != null) {
                    balancer = newBalancer;
                    this.perTableBalancers.put(tableId, balancer);
                    balancer.init(this.context);
                }
                log.info("Loaded new class {} for table {}", (Object)clazzName, (Object)tableId);
            }
            catch (Exception e) {
                log.warn("Failed to load table balancer class {} for table {}", new Object[]{clazzName, tableId, e});
            }
        }
        if (balancer == null) {
            try {
                balancer = this.constructNewBalancerForTable(clazzName, tableId);
                log.info("Loaded class {} for table {}", (Object)clazzName, (Object)tableId);
            }
            catch (Exception e) {
                log.warn("Failed to load table balancer class {} for table {}", new Object[]{clazzName, tableId, e});
            }
            if (balancer == null) {
                log.info("Using balancer {} for table {}", (Object)DefaultLoadBalancer.class.getName(), (Object)tableId);
                balancer = new DefaultLoadBalancer(tableId);
            }
            this.perTableBalancers.put(tableId, balancer);
            balancer.init(this.context);
        }
        return balancer;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        HashMap groupedUnassigned = new HashMap();
        unassigned.forEach((ke, lastTserver) -> groupedUnassigned.computeIfAbsent(ke.tableId(), k -> new HashMap()).put(ke, lastTserver));
        for (Map.Entry e : groupedUnassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> newAssignments = new HashMap<KeyExtent, TServerInstance>();
            this.getBalancerForTable((TableId)e.getKey()).getAssignments(current, (Map)e.getValue(), newAssignments);
            assignments.putAll(newAssignments);
        }
    }

    protected TableOperations getTableOperations() {
        if (this.tops == null) {
            this.tops = this.context.tableOperations();
        }
        return this.tops;
    }

    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        long minBalanceTime = 5000L;
        TableOperations t = this.getTableOperations();
        if (t == null) {
            return minBalanceTime;
        }
        for (String s : t.tableIdMap().values()) {
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            long tableBalanceTime = this.getBalancerForTable(TableId.of((String)s)).balance(current, migrations, newMigrations);
            if (tableBalanceTime < minBalanceTime) {
                minBalanceTime = tableBalanceTime;
            }
            migrationsOut.addAll(newMigrations);
        }
        return minBalanceTime;
    }
}

