/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.clientImpl.bulk.BulkImport;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.MapFileInfo;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.rpc.clients.ThriftClientTypes;
import org.apache.accumulo.core.spi.crypto.CryptoService;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.StopWatch;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkImporter {
    private static final Logger log = LoggerFactory.getLogger(BulkImporter.class);
    private StopWatch<Timers> timer;
    private final ServerContext context;
    private TableId tableId;
    private long tid;
    private boolean setTime;
    private TableConfiguration tableConf;
    static final byte[] byte0 = new byte[]{0};

    public static List<String> bulkLoad(ServerContext context, long tid, String tableId, List<String> files, boolean setTime) throws IOException {
        AssignmentStats stats = new BulkImporter(context, tid, tableId, setTime).importFiles(files);
        ArrayList<String> result = new ArrayList<String>();
        for (Path p : stats.completeFailures.keySet()) {
            result.add(p.toString());
        }
        return result;
    }

    public BulkImporter(ServerContext context, long tid, String tableId, boolean setTime) {
        this.context = context;
        this.tid = tid;
        this.tableId = TableId.of((String)tableId);
        this.setTime = setTime;
        this.tableConf = context.getTableConfiguration(this.tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssignmentStats importFiles(List<String> files) {
        int numThreads = this.context.getConfiguration().getCount(Property.TSERV_BULK_PROCESS_THREADS);
        int numAssignThreads = this.context.getConfiguration().getCount(Property.TSERV_BULK_ASSIGNMENT_THREADS);
        this.timer = new StopWatch(Timers.class);
        this.timer.start((Enum)Timers.TOTAL);
        VolumeManager fs = this.context.getVolumeManager();
        HashSet<Path> paths = new HashSet<Path>();
        for (String file : files) {
            paths.add(new Path(file));
        }
        AssignmentStats assignmentStats = new AssignmentStats(paths.size());
        SortedMap<Path, List<KeyExtent>> completeFailures = Collections.synchronizedSortedMap(new TreeMap());
        TServiceClient client = null;
        TabletLocator locator = TabletLocator.getLocator((ClientContext)this.context, (TableId)this.tableId);
        try {
            SortedMap<Path, List<TabletLocator.TabletLocation>> assignments = Collections.synchronizedSortedMap(new TreeMap());
            this.timer.start((Enum)Timers.EXAMINE_MAP_FILES);
            ThreadPoolExecutor threadPool = ThreadPools.getServerThreadPools().getPoolBuilder("bulk.import.find.overlapping").numCoreThreads(numThreads).enableThreadPoolMetrics().build();
            for (Path path : paths) {
                Path mapFile = path;
                Runnable runnable = () -> {
                    List<Object> tabletsToAssignMapFileTo = Collections.emptyList();
                    try {
                        tabletsToAssignMapFileTo = BulkImporter.findOverlappingTablets(this.context, fs, locator, mapFile, this.tableConf.getCryptoService());
                    }
                    catch (Exception ex) {
                        log.warn("Unable to find tablets that overlap file " + String.valueOf(mapFile), (Throwable)ex);
                    }
                    log.debug("Map file {} found to overlap {} tablets", (Object)mapFile, (Object)tabletsToAssignMapFileTo.size());
                    if (tabletsToAssignMapFileTo.isEmpty()) {
                        List empty = Collections.emptyList();
                        completeFailures.put(mapFile, empty);
                    } else {
                        assignments.put(mapFile, tabletsToAssignMapFileTo);
                    }
                };
                threadPool.execute(runnable);
            }
            threadPool.shutdown();
            while (!threadPool.isTerminated()) {
                try {
                    threadPool.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.timer.stop((Enum)Timers.EXAMINE_MAP_FILES);
            assignmentStats.attemptingAssignments(assignments);
            Map<Path, List<KeyExtent>> assignmentFailures = this.assignMapFiles(fs, assignments, paths, numAssignThreads, numThreads);
            assignmentStats.assignmentsFailed(assignmentFailures);
            TreeMap<Path, Integer> failureCount = new TreeMap<Path, Integer>();
            for (Map.Entry entry : assignmentFailures.entrySet()) {
                failureCount.put((Path)entry.getKey(), 1);
            }
            long sleepTime = 2000L;
            while (!assignmentFailures.isEmpty()) {
                sleepTime = Math.min(sleepTime * 2L, TimeUnit.MINUTES.toMillis(1L));
                locator.invalidateCache();
                this.timer.start((Enum)Timers.SLEEP);
                UtilWaitThread.sleepUninterruptibly((long)sleepTime, (TimeUnit)TimeUnit.MILLISECONDS);
                this.timer.stop((Enum)Timers.SLEEP);
                log.debug("Trying to assign {} map files that previously failed on some key extents", (Object)assignmentFailures.size());
                assignments.clear();
                for (Map.Entry<Path, List<KeyExtent>> entry : assignmentFailures.entrySet()) {
                    Iterator<KeyExtent> keListIter = entry.getValue().iterator();
                    ArrayList<TabletLocator.TabletLocation> tabletsToAssignMapFileTo = new ArrayList<TabletLocator.TabletLocation>();
                    while (keListIter.hasNext()) {
                        KeyExtent ke = keListIter.next();
                        this.timer.start((Enum)Timers.QUERY_METADATA);
                        try {
                            tabletsToAssignMapFileTo.addAll(BulkImporter.findOverlappingTablets(this.context, fs, locator, entry.getKey(), ke, this.tableConf.getCryptoService()));
                            keListIter.remove();
                        }
                        catch (Exception ex) {
                            log.warn("Exception finding overlapping tablets, will retry tablet " + String.valueOf(ke), (Throwable)ex);
                        }
                        this.timer.stop((Enum)Timers.QUERY_METADATA);
                    }
                    if (tabletsToAssignMapFileTo.isEmpty()) continue;
                    assignments.put(entry.getKey(), tabletsToAssignMapFileTo);
                }
                assignmentStats.attemptingAssignments(assignments);
                Map<Path, List<KeyExtent>> assignmentFailures2 = this.assignMapFiles(fs, assignments, paths, numAssignThreads, numThreads);
                assignmentStats.assignmentsFailed(assignmentFailures2);
                for (Map.Entry<Path, List<KeyExtent>> entry3 : assignmentFailures2.entrySet()) {
                    assignmentFailures.get(entry3.getKey()).addAll((Collection<KeyExtent>)entry3.getValue());
                    Integer fc = (Integer)failureCount.get(entry3.getKey());
                    if (fc == null) {
                        fc = 0;
                    }
                    failureCount.put(entry3.getKey(), fc + 1);
                }
                assignmentFailures.values().removeIf(List::isEmpty);
                Set set = failureCount.entrySet();
                for (Map.Entry entry4 : set) {
                    int retries = this.context.getConfiguration().getCount(Property.TSERV_BULK_RETRY);
                    if ((Integer)entry4.getValue() <= retries || assignmentFailures.get(entry4.getKey()) == null) continue;
                    log.error("Map file {} failed more than {} times, giving up.", entry4.getKey(), (Object)retries);
                    completeFailures.put((Path)entry4.getKey(), assignmentFailures.get(entry4.getKey()));
                    assignmentFailures.remove(entry4.getKey());
                }
            }
            assignmentStats.assignmentsAbandoned(completeFailures);
            Set<Path> failedFailures = this.processFailures(completeFailures);
            assignmentStats.unrecoveredMapFiles(failedFailures);
            this.timer.stop((Enum)Timers.TOTAL);
            this.printReport(paths);
            AssignmentStats assignmentStats2 = assignmentStats;
            return assignmentStats2;
        }
        finally {
            if (client != null) {
                ThriftUtil.close(client, (ClientContext)this.context);
            }
        }
    }

    private void printReport(Set<Path> paths) {
        long totalTime = 0L;
        for (Timers t : Timers.values()) {
            if (t == Timers.TOTAL) continue;
            totalTime += this.timer.get((Enum)t);
        }
        ArrayList<String> files = new ArrayList<String>();
        for (Path path : paths) {
            files.add(path.getName());
        }
        Collections.sort(files);
        log.debug("BULK IMPORT TIMING STATISTICS");
        log.debug("Files: {}", files);
        log.debug(String.format("Examine map files    : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.EXAMINE_MAP_FILES), 100.0 * (double)this.timer.get((Enum)Timers.EXAMINE_MAP_FILES) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Query %-14s : %,10.2f secs %6.2f%s", MetadataTable.NAME, this.timer.getSecs((Enum)Timers.QUERY_METADATA), 100.0 * (double)this.timer.get((Enum)Timers.QUERY_METADATA) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Import Map Files     : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.IMPORT_MAP_FILES), 100.0 * (double)this.timer.get((Enum)Timers.IMPORT_MAP_FILES) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Sleep                : %,10.2f secs %6.2f%s", this.timer.getSecs((Enum)Timers.SLEEP), 100.0 * (double)this.timer.get((Enum)Timers.SLEEP) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Misc                 : %,10.2f secs %6.2f%s", (double)(this.timer.get((Enum)Timers.TOTAL) - totalTime) / 1000.0, 100.0 * (double)(this.timer.get((Enum)Timers.TOTAL) - totalTime) / (double)this.timer.get((Enum)Timers.TOTAL), "%"));
        log.debug(String.format("Total                : %,10.2f secs", this.timer.getSecs((Enum)Timers.TOTAL)));
    }

    private Set<Path> processFailures(Map<Path, List<KeyExtent>> completeFailures) {
        Set<Map.Entry<Path, List<KeyExtent>>> es = completeFailures.entrySet();
        if (completeFailures.isEmpty()) {
            return Collections.emptySet();
        }
        log.debug("The following map files failed ");
        for (Map.Entry<Path, List<KeyExtent>> entry : es) {
            List<KeyExtent> extents = entry.getValue();
            for (KeyExtent keyExtent : extents) {
                log.debug("\t{} -> {}", (Object)entry.getKey(), (Object)keyExtent);
            }
        }
        return Collections.emptySet();
    }

    private static List<KeyExtent> extentsOf(List<TabletLocator.TabletLocation> locations) {
        ArrayList<KeyExtent> result = new ArrayList<KeyExtent>(locations.size());
        for (TabletLocator.TabletLocation tl : locations) {
            result.add(tl.tablet_extent);
        }
        return result;
    }

    private Map<Path, List<AssignmentInfo>> estimateSizes(VolumeManager vm, Map<Path, List<TabletLocator.TabletLocation>> assignments, Collection<Path> paths, int numThreads) {
        long t1 = System.currentTimeMillis();
        TreeMap<Path, Long> mapFileSizes = new TreeMap<Path, Long>();
        try {
            for (Path path : paths) {
                FileSystem fs = vm.getFileSystemByPath(path);
                mapFileSizes.put(path, fs.getContentSummary(path).getLength());
            }
        }
        catch (IOException e) {
            log.error("Failed to get map files in for {}: {}", new Object[]{paths, e.getMessage(), e});
            throw new RuntimeException(e);
        }
        Map<Path, List<AssignmentInfo>> ais = Collections.synchronizedMap(new TreeMap());
        ThreadPoolExecutor threadPool = ThreadPools.getServerThreadPools().getPoolBuilder("bulk.import.size.estimate").numCoreThreads(numThreads).build();
        for (Map.Entry entry : assignments.entrySet()) {
            if (((List)entry.getValue()).size() == 1) {
                TabletLocator.TabletLocation tabletLocation = (TabletLocator.TabletLocation)((List)entry.getValue()).get(0);
                ais.put((Path)entry.getKey(), Collections.singletonList(new AssignmentInfo(tabletLocation.tablet_extent, (Long)mapFileSizes.get(entry.getKey()))));
                continue;
            }
            Runnable estimationTask = () -> {
                Map<KeyExtent, Long> estimatedSizes = null;
                try {
                    Path mapFile = (Path)entry.getKey();
                    FileSystem ns = this.context.getVolumeManager().getFileSystemByPath(mapFile);
                    estimatedSizes = BulkImport.estimateSizes((AccumuloConfiguration)this.context.getConfiguration(), (Path)mapFile, (long)((Long)mapFileSizes.get(entry.getKey())), BulkImporter.extentsOf((List)entry.getValue()), (FileSystem)ns, null, (CryptoService)this.tableConf.getCryptoService());
                }
                catch (IOException e) {
                    log.warn("Failed to estimate map file sizes {}", (Object)e.getMessage());
                }
                if (estimatedSizes == null) {
                    estimatedSizes = new TreeMap();
                    long estSize = (long)((double)((Long)mapFileSizes.get(entry.getKey())).longValue() / (double)((List)entry.getValue()).size());
                    for (TabletLocator.TabletLocation tl : (List)entry.getValue()) {
                        estimatedSizes.put(tl.tablet_extent, estSize);
                    }
                }
                ArrayList<AssignmentInfo> assignmentInfoList = new ArrayList<AssignmentInfo>(estimatedSizes.size());
                for (Map.Entry entry2 : estimatedSizes.entrySet()) {
                    assignmentInfoList.add(new AssignmentInfo((KeyExtent)entry2.getKey(), (Long)entry2.getValue()));
                }
                ais.put((Path)entry.getKey(), assignmentInfoList);
            };
            threadPool.execute(estimationTask);
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            try {
                threadPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Encountered InterruptedException while waiting for the threadPool to terminate.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        long t2 = System.currentTimeMillis();
        log.debug(String.format("Estimated map files sizes in %6.2f secs", (double)(t2 - t1) / 1000.0));
        return ais;
    }

    private static Map<KeyExtent, String> locationsOf(Map<Path, List<TabletLocator.TabletLocation>> assignments) {
        HashMap<KeyExtent, String> result = new HashMap<KeyExtent, String>();
        for (List<TabletLocator.TabletLocation> entry : assignments.values()) {
            for (TabletLocator.TabletLocation tl : entry) {
                result.put(tl.tablet_extent, tl.tablet_location);
            }
        }
        return result;
    }

    private Map<Path, List<KeyExtent>> assignMapFiles(VolumeManager fs, Map<Path, List<TabletLocator.TabletLocation>> assignments, Collection<Path> paths, int numThreads, int numMapThreads) {
        this.timer.start((Enum)Timers.EXAMINE_MAP_FILES);
        Map<Path, List<AssignmentInfo>> assignInfo = this.estimateSizes(fs, assignments, paths, numMapThreads);
        this.timer.stop((Enum)Timers.EXAMINE_MAP_FILES);
        this.timer.start((Enum)Timers.IMPORT_MAP_FILES);
        Map<Path, List<KeyExtent>> ret = this.assignMapFiles(assignInfo, BulkImporter.locationsOf(assignments), numThreads);
        this.timer.stop((Enum)Timers.IMPORT_MAP_FILES);
        return ret;
    }

    private Map<Path, List<KeyExtent>> assignMapFiles(Map<Path, List<AssignmentInfo>> assignments, Map<KeyExtent, String> locations, int numThreads) {
        TreeMap<KeyExtent, List> assignmentsPerTablet = new TreeMap<KeyExtent, List>();
        assignments.forEach((mapFile, tabletsToAssignMapFileTo) -> tabletsToAssignMapFileTo.forEach(assignmentInfo -> assignmentsPerTablet.computeIfAbsent(assignmentInfo.ke, k -> new ArrayList()).add(new PathSize((Path)mapFile, assignmentInfo.estSize))));
        Map<Path, List<KeyExtent>> assignmentFailures = Collections.synchronizedMap(new TreeMap());
        TreeMap assignmentsPerTabletServer = new TreeMap();
        assignmentsPerTablet.forEach((ke, pathSizes) -> {
            String location = (String)locations.get(ke);
            if (location == null) {
                Map map = assignmentFailures;
                synchronized (map) {
                    pathSizes.forEach(pathSize -> assignmentFailures.computeIfAbsent(pathSize.path, k -> new ArrayList()).add(ke));
                }
                log.warn("Could not assign {} map files to tablet {} because it had no location, will retry ...", (Object)pathSizes.size(), ke);
            } else {
                assignmentsPerTabletServer.computeIfAbsent(location, k -> new TreeMap()).put(ke, pathSizes);
            }
        });
        ThreadPoolExecutor threadPool = ThreadPools.getServerThreadPools().getPoolBuilder("bulk.import.submit").numCoreThreads(numThreads).build();
        for (Map.Entry entry : assignmentsPerTabletServer.entrySet()) {
            String location = (String)entry.getKey();
            threadPool.execute(new AssignmentTask(assignmentFailures, location, (Map)entry.getValue()));
        }
        threadPool.shutdown();
        while (!threadPool.isTerminated()) {
            try {
                threadPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Encountered InterruptedException while waiting for the thread pool to terminate.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return assignmentFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<KeyExtent> assignMapFiles(ClientContext context, HostAndPort location, Map<KeyExtent, List<PathSize>> assignmentsPerTablet) throws AccumuloException, AccumuloSecurityException {
        List<KeyExtent> list;
        long timeInMillis = context.getConfiguration().getTimeInMillis(Property.TSERV_BULK_TIMEOUT);
        TabletClientService.Iface client = (TabletClientService.Iface)ThriftUtil.getClient((ThriftClientTypes)ThriftClientTypes.TABLET_SERVER, (HostAndPort)location, (ClientContext)context, (long)timeInMillis);
        try {
            HashMap files = new HashMap();
            for (Map.Entry<KeyExtent, List<PathSize>> entry2 : assignmentsPerTablet.entrySet()) {
                HashMap<String, MapFileInfo> tabletFiles = new HashMap<String, MapFileInfo>();
                files.put(entry2.getKey(), tabletFiles);
                for (PathSize pathSize : entry2.getValue()) {
                    MapFileInfo mfi = new MapFileInfo(pathSize.estSize);
                    tabletFiles.put(pathSize.path.toString(), mfi);
                }
            }
            log.debug("Asking {} to bulk load {}", (Object)location, files);
            List failures = client.bulkImport(TraceUtil.traceInfo(), context.rpcCreds(), this.tid, files.entrySet().stream().collect(Collectors.toMap(entry -> ((KeyExtent)entry.getKey()).toThrift(), Map.Entry::getValue)), this.setTime);
            list = failures.stream().map(KeyExtent::fromThrift).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
                throw throwable;
            }
            catch (ThriftSecurityException e) {
                throw new AccumuloSecurityException(e.user, e.code, (Throwable)e);
            }
            catch (Exception t) {
                log.error("Encountered unknown exception in assignMapFiles asking {} to bulk import.", (Object)location, (Object)t);
                throw new AccumuloException((Throwable)t);
            }
        }
        ThriftUtil.returnClient((TServiceClient)((TServiceClient)client), (ClientContext)context);
        return list;
    }

    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ServerContext context, VolumeManager fs, TabletLocator locator, Path file, CryptoService cs) throws Exception {
        return BulkImporter.findOverlappingTablets(context, fs, locator, file, null, null, cs);
    }

    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ServerContext context, VolumeManager fs, TabletLocator locator, Path file, KeyExtent failed, CryptoService cs) throws Exception {
        locator.invalidateCache(failed);
        Text start = BulkImporter.getStartRowForExtent(failed);
        return BulkImporter.findOverlappingTablets(context, fs, locator, file, start, failed.endRow(), cs);
    }

    protected static Text getStartRowForExtent(KeyExtent extent) {
        Text start = extent.prevEndRow();
        if (start != null) {
            start = new Text(start);
            start.append(byte0, 0, 1);
        }
        return start;
    }

    public static List<TabletLocator.TabletLocation> findOverlappingTablets(ServerContext context, VolumeManager vm, TabletLocator locator, Path file, Text startRow, Text endRow, CryptoService cs) throws Exception {
        ArrayList<TabletLocator.TabletLocation> result = new ArrayList<TabletLocator.TabletLocation>();
        List columnFamilies = Collections.emptyList();
        String filename = file.toString();
        FileSystem fs = vm.getFileSystemByPath(file);
        try (FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(filename, fs, fs.getConf(), cs).withTableConfiguration(context.getConfiguration()).seekToBeginning().build();){
            Text row = startRow;
            if (row == null) {
                row = new Text();
            }
            while (true) {
                reader.seek(new Range(row, null), columnFamilies, false);
                if (!reader.hasTop()) {
                } else {
                    row = ((Key)reader.getTopKey()).getRow();
                    TabletLocator.TabletLocation tabletLocation = locator.locateTablet((ClientContext)context, row, false, true);
                    result.add(tabletLocation);
                    row = tabletLocation.tablet_extent.endRow();
                    if (row != null && (endRow == null || row.compareTo((BinaryComparable)endRow) < 0)) {
                        row = new Text(row);
                        row.append(byte0, 0, byte0.length);
                        continue;
                    }
                }
                break;
            }
        }
        return result;
    }

    public static class AssignmentStats {
        private Map<KeyExtent, Integer> counts = new HashMap<KeyExtent, Integer>();
        private int numUniqueMapFiles;
        private Map<Path, List<KeyExtent>> completeFailures = null;
        private Set<Path> failedFailures = null;

        AssignmentStats(int fileCount) {
            this.numUniqueMapFiles = fileCount;
        }

        void attemptingAssignments(Map<Path, List<TabletLocator.TabletLocation>> assignments) {
            for (Map.Entry<Path, List<TabletLocator.TabletLocation>> entry : assignments.entrySet()) {
                for (TabletLocator.TabletLocation tl : entry.getValue()) {
                    Integer count = this.getCount(tl.tablet_extent);
                    this.counts.put(tl.tablet_extent, count + 1);
                }
            }
        }

        void assignmentsFailed(Map<Path, List<KeyExtent>> assignmentFailures) {
            for (Map.Entry<Path, List<KeyExtent>> entry : assignmentFailures.entrySet()) {
                for (KeyExtent ke : entry.getValue()) {
                    Integer count = this.getCount(ke);
                    this.counts.put(ke, count - 1);
                }
            }
        }

        void assignmentsAbandoned(Map<Path, List<KeyExtent>> completeFailures) {
            this.completeFailures = completeFailures;
        }

        private Integer getCount(KeyExtent parent) {
            Integer count = this.counts.get(parent);
            if (count == null) {
                count = 0;
            }
            return count;
        }

        void unrecoveredMapFiles(Set<Path> failedFailures) {
            this.failedFailures = failedFailures;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int totalAssignments = 0;
            int tabletsImportedTo = 0;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (Map.Entry<KeyExtent, Integer> entry : this.counts.entrySet()) {
                totalAssignments += entry.getValue().intValue();
                if (entry.getValue() > 0) {
                    ++tabletsImportedTo;
                }
                if (entry.getValue() < min) {
                    min = entry.getValue();
                }
                if (entry.getValue() <= max) continue;
                max = entry.getValue();
            }
            double stddev = 0.0;
            for (Map.Entry<KeyExtent, Integer> entry : this.counts.entrySet()) {
                stddev += Math.pow((double)entry.getValue().intValue() - (double)totalAssignments / (double)this.counts.size(), 2.0);
            }
            stddev /= (double)this.counts.size();
            stddev = Math.sqrt(stddev);
            HashSet<KeyExtent> failedTablets = new HashSet<KeyExtent>();
            for (List<KeyExtent> ft : this.completeFailures.values()) {
                failedTablets.addAll(ft);
            }
            sb.append("BULK IMPORT ASSIGNMENT STATISTICS\n");
            sb.append(String.format("# of map files            : %,10d%n", this.numUniqueMapFiles));
            sb.append(String.format("# map files with failures : %,10d %6.2f%s%n", this.completeFailures.size(), (double)this.completeFailures.size() * 100.0 / (double)this.numUniqueMapFiles, "%"));
            sb.append(String.format("# failed failed map files : %,10d %s%n", this.failedFailures.size(), this.failedFailures.isEmpty() ? "" : " <-- THIS IS BAD"));
            sb.append(String.format("# of tablets              : %,10d%n", this.counts.size()));
            sb.append(String.format("# tablets imported to     : %,10d %6.2f%s%n", tabletsImportedTo, (double)tabletsImportedTo * 100.0 / (double)this.counts.size(), "%"));
            sb.append(String.format("# tablets with failures   : %,10d %6.2f%s%n", failedTablets.size(), (double)failedTablets.size() * 100.0 / (double)this.counts.size(), "%"));
            sb.append(String.format("min map files per tablet  : %,10d%n", min));
            sb.append(String.format("max map files per tablet  : %,10d%n", max));
            sb.append(String.format("avg map files per tablet  : %,10.2f (std dev = %.2f)%n", (double)totalAssignments / (double)this.counts.size(), stddev));
            return sb.toString();
        }
    }

    private static enum Timers {
        EXAMINE_MAP_FILES,
        QUERY_METADATA,
        IMPORT_MAP_FILES,
        SLEEP,
        TOTAL;

    }

    private static class AssignmentInfo {
        KeyExtent ke;
        long estSize;

        public AssignmentInfo(KeyExtent keyExtent, Long estSize) {
            this.ke = keyExtent;
            this.estSize = estSize;
        }
    }

    private class AssignmentTask
    implements Runnable {
        final Map<Path, List<KeyExtent>> assignmentFailures;
        HostAndPort location;
        private Map<KeyExtent, List<PathSize>> assignmentsPerTablet;

        public AssignmentTask(Map<Path, List<KeyExtent>> assignmentFailures, String location, Map<KeyExtent, List<PathSize>> assignmentsPerTablet) {
            this.assignmentFailures = assignmentFailures;
            this.location = HostAndPort.fromString((String)location);
            this.assignmentsPerTablet = assignmentsPerTablet;
        }

        private void handleFailures(Collection<KeyExtent> failures, String message) {
            failures.forEach(ke -> {
                List<PathSize> mapFiles = this.assignmentsPerTablet.get(ke);
                Map<Path, List<KeyExtent>> map = this.assignmentFailures;
                synchronized (map) {
                    mapFiles.forEach(pathSize -> this.assignmentFailures.computeIfAbsent(pathSize.path, k -> new ArrayList()).add(ke));
                }
                log.info("Could not assign {} map files to tablet {} because : {}.  Will retry ...", new Object[]{mapFiles.size(), ke, message});
            });
        }

        @Override
        public void run() {
            HashSet<Path> uniqMapFiles = new HashSet<Path>();
            for (List<PathSize> mapFiles : this.assignmentsPerTablet.values()) {
                for (PathSize ps : mapFiles) {
                    uniqMapFiles.add(ps.path);
                }
            }
            log.debug("Assigning {} map files to {} tablets at {}", new Object[]{uniqMapFiles.size(), this.assignmentsPerTablet.size(), this.location});
            try {
                List<KeyExtent> failures = BulkImporter.this.assignMapFiles(BulkImporter.this.context, this.location, this.assignmentsPerTablet);
                this.handleFailures(failures, "Not Serving Tablet");
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                this.handleFailures(this.assignmentsPerTablet.keySet(), e.getMessage());
            }
        }
    }

    private static class PathSize {
        Path path;
        long estSize;

        public PathSize(Path mapFile, long estSize) {
            this.path = mapFile;
            this.estSize = estSize;
        }

        public String toString() {
            return String.valueOf(this.path) + " " + this.estSize;
        }
    }
}

