/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.IntSupplier;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.server.metrics.NoopMetrics;

public class TabletServerScanMetrics
implements MetricsProducer {
    private final IntSupplier openFiles;
    private Timer scans = NoopMetrics.useNoopTimer();
    private DistributionSummary resultsPerScan = NoopMetrics.useNoopDistributionSummary();
    private DistributionSummary yields = NoopMetrics.useNoopDistributionSummary();
    private Counter startScanCalls = NoopMetrics.useNoopCounter();
    private Counter continueScanCalls = NoopMetrics.useNoopCounter();
    private Counter closeScanCalls = NoopMetrics.useNoopCounter();
    private Counter busyTimeoutCount = NoopMetrics.useNoopCounter();
    private final AtomicLong zombieScanThreads = new AtomicLong(0L);
    private final LongAdder lookupCount = new LongAdder();
    private final LongAdder queryResultCount = new LongAdder();
    private final LongAdder queryResultBytes = new LongAdder();
    private final LongAdder scannedCount = new LongAdder();

    public void incrementLookupCount(long amount) {
        this.lookupCount.add(amount);
    }

    public long getLookupCount() {
        return this.lookupCount.sum();
    }

    public void incrementQueryResultCount(long amount) {
        this.queryResultCount.add(amount);
    }

    public long getQueryResultCount() {
        return this.queryResultCount.sum();
    }

    public void incrementQueryResultBytes(long amount) {
        this.queryResultBytes.add(amount);
    }

    public long getQueryByteCount() {
        return this.queryResultBytes.sum();
    }

    public void incrementScannedCount(long amount) {
        this.scannedCount.add(amount);
    }

    public LongAdder getScannedCounter() {
        return this.scannedCount;
    }

    public long getScannedCount() {
        return this.scannedCount.sum();
    }

    public void addScan(long value) {
        this.scans.record(Duration.ofMillis(value));
    }

    public void addResult(long value) {
        this.resultsPerScan.record((double)value);
    }

    public void addYield(long value) {
        this.yields.record((double)value);
    }

    public void incrementStartScan(double value) {
        this.startScanCalls.increment(value);
    }

    public void incrementContinueScan(double value) {
        this.continueScanCalls.increment(value);
    }

    public void incrementCloseScan(double value) {
        this.closeScanCalls.increment(value);
    }

    public void incrementBusy(double value) {
        this.busyTimeoutCount.increment(value);
    }

    public void setZombieScanThreads(long count) {
        this.zombieScanThreads.set(count);
    }

    public long getZombieThreadsCount() {
        return this.zombieScanThreads.get();
    }

    public TabletServerScanMetrics(IntSupplier openFileSupplier) {
        this.openFiles = openFileSupplier;
    }

    public void registerMetrics(MeterRegistry registry) {
        Gauge.builder((String)"accumulo.scan.files.open", this.openFiles::getAsInt).description("Number of files open for scans").register(registry);
        this.scans = Timer.builder((String)"accumulo.scan.times").description("Scans").register(registry);
        this.resultsPerScan = DistributionSummary.builder((String)"accumulo.scan.result").description("Results per scan").register(registry);
        this.yields = DistributionSummary.builder((String)"accumulo.scan.yields").description("yields").register(registry);
        this.startScanCalls = Counter.builder((String)"accumulo.scan.start").description("calls to start a scan / multiscan").register(registry);
        this.continueScanCalls = Counter.builder((String)"accumulo.scan.continue").description("calls to continue a scan / multiscan").register(registry);
        this.closeScanCalls = Counter.builder((String)"accumulo.scan.close").description("calls to close a scan / multiscan").register(registry);
        this.busyTimeoutCount = Counter.builder((String)"accumulo.scan.busy.timeout.count").description("The number of scans where a busy timeout happened").register(registry);
        Gauge.builder((String)"accumulo.scan.queries", (Object)this, TabletServerScanMetrics::getLookupCount).description("Number of queries").register(registry);
        Gauge.builder((String)"accumulo.scan.query.results", (Object)this, TabletServerScanMetrics::getQueryResultCount).description("Query rate (entries/sec)").register(registry);
        Gauge.builder((String)"accumulo.scan.query.results.bytes", (Object)this, TabletServerScanMetrics::getQueryByteCount).description("Query rate (bytes/sec)").register(registry);
        Gauge.builder((String)"accumulo.scan.query.scanned.entries", (Object)this, TabletServerScanMetrics::getScannedCount).description("Scanned rate").register(registry);
        Gauge.builder((String)"accumulo.scan.zombie.threads", (Object)this, TabletServerScanMetrics::getZombieThreadsCount).description("Number of scan threads that have no associated client session").register(registry);
    }
}

