/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.tserver.ConditionalMutationSet;
import org.apache.accumulo.tserver.data.ServerConditionalMutation;

class RowLocks {
    private final Map<ByteSequence, RowLock> rowLocks = new ConcurrentHashMap<ByteSequence, RowLock>();

    RowLocks() {
    }

    private RowLock getRowLock(ArrayByteSequence rowSeq) {
        return this.rowLocks.compute((ByteSequence)rowSeq, (key, value) -> {
            if (value == null) {
                return new RowLock(new ReentrantLock(), (ByteSequence)rowSeq);
            }
            ++value.count;
            return value;
        });
    }

    private void returnRowLock(RowLock lock) {
        Objects.requireNonNull(lock);
        this.rowLocks.compute(lock.rowSeq, (key, value) -> {
            Preconditions.checkState((value == lock ? 1 : 0) != 0);
            Preconditions.checkState((value.count > 0 ? 1 : 0) != 0);
            return --value.count > 0 ? value : null;
        });
    }

    List<RowLock> acquireRowlocks(Map<KeyExtent, List<ServerConditionalMutation>> updates, Map<KeyExtent, List<ServerConditionalMutation>> deferred) {
        ArrayList<RowLock> locks = new ArrayList<RowLock>();
        for (List<ServerConditionalMutation> list : updates.values()) {
            for (ServerConditionalMutation scm : list) {
                locks.add(this.getRowLock(new ArrayByteSequence(scm.getRow())));
            }
        }
        HashSet<ByteSequence> rowsNotLocked = null;
        if (locks.size() > 1) {
            for (RowLock rowLock : locks) {
                if (rowLock.tryLock()) continue;
                if (rowsNotLocked == null) {
                    rowsNotLocked = new HashSet<ByteSequence>();
                }
                rowsNotLocked.add(rowLock.rowSeq);
            }
        } else {
            ((RowLock)locks.get(0)).lock();
        }
        if (rowsNotLocked != null) {
            final HashSet<ByteSequence> hashSet = rowsNotLocked;
            ConditionalMutationSet.defer(updates, deferred, new ConditionalMutationSet.DeferFilter(){

                @Override
                public void defer(List<ServerConditionalMutation> scml, List<ServerConditionalMutation> okMutations, List<ServerConditionalMutation> deferred) {
                    for (ServerConditionalMutation scm : scml) {
                        if (hashSet.contains(new ArrayByteSequence(scm.getRow()))) {
                            deferred.add(scm);
                            continue;
                        }
                        okMutations.add(scm);
                    }
                }
            });
            ArrayList<RowLock> filteredLocks = new ArrayList<RowLock>();
            ArrayList<RowLock> locksToReturn = new ArrayList<RowLock>();
            for (RowLock rowLock : locks) {
                if (rowsNotLocked.contains(rowLock.rowSeq)) {
                    locksToReturn.add(rowLock);
                    continue;
                }
                filteredLocks.add(rowLock);
            }
            for (RowLock rowLock : locksToReturn) {
                this.returnRowLock(rowLock);
            }
            locks = filteredLocks;
        }
        return locks;
    }

    void releaseRowLocks(List<RowLock> locks) {
        for (RowLock rowLock : locks) {
            rowLock.unlock();
        }
        for (RowLock rowLock : locks) {
            this.returnRowLock(rowLock);
        }
    }

    static class RowLock {
        ReentrantLock rlock;
        int count;
        ByteSequence rowSeq;

        RowLock(ReentrantLock rlock, ByteSequence rowSeq) {
            this.rlock = rlock;
            this.count = 1;
            this.rowSeq = rowSeq;
        }

        public boolean tryLock() {
            return this.rlock.tryLock();
        }

        public void lock() {
            this.rlock.lock();
        }

        public void unlock() {
            this.rlock.unlock();
        }
    }
}

