/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.delete;

import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.compact.cancel.CancelCompactions;
import org.apache.accumulo.manager.tableOps.delete.DeleteTable;
import org.apache.zookeeper.KeeperException;

public class PreDeleteTable
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final NamespaceId namespaceId;

    public static String createDeleteMarkerPath(InstanceId instanceId, TableId tableId) {
        return "/accumulo/" + String.valueOf(instanceId) + "/tables/" + tableId.canonical() + "/deleting";
    }

    public PreDeleteTable(NamespaceId namespaceId, TableId tableId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.DELETE) + Utils.reserveTable(env, this.tableId, tid, false, true, TableOperation.DELETE);
    }

    private void preventFutureCompactions(Manager environment) throws KeeperException, InterruptedException {
        String deleteMarkerPath = PreDeleteTable.createDeleteMarkerPath(environment.getInstanceID(), this.tableId);
        ZooReaderWriter zoo = environment.getContext().getZooReaderWriter();
        zoo.putPersistentData(deleteMarkerPath, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        try {
            this.preventFutureCompactions(environment);
            CancelCompactions.mutateZooKeeper(tid, this.tableId, environment);
            DeleteTable deleteTable = new DeleteTable(this.namespaceId, this.tableId);
            return deleteTable;
        }
        finally {
            Utils.unreserveTable(environment, this.tableId, tid, false);
            Utils.unreserveNamespace(environment, this.namespaceId, tid, false);
        }
    }

    @Override
    public void undo(long tid, Manager env) {
        Utils.unreserveTable(env, this.tableId, tid, false);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }
}

