/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespaces;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.AbstractId;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.core.fate.zookeeper.FateLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooReservation;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.tables.TableNameUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final byte[] ZERO_BYTE = new byte[]{48};
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    static final Lock tableNameLock = new ReentrantLock();
    static final Lock idLock = new ReentrantLock();

    public static void checkTableNameDoesNotExist(ServerContext context, String tableName, NamespaceId destNamespaceId, TableId tableId, TableOperation operation) throws AcceptableThriftTableOperationException {
        String newTableName = (String)TableNameUtil.qualify((String)tableName).getSecond();
        try {
            for (String tid : context.getZooReader().getChildren(context.getZooKeeperRoot() + "/tables")) {
                String zTablePath = context.getZooKeeperRoot() + "/tables/" + tid;
                try {
                    byte[] tname = context.getZooReader().getData(zTablePath + "/name");
                    if (!newTableName.equals(new String(tname, StandardCharsets.UTF_8))) continue;
                    byte[] nId = context.getZooReader().getData(zTablePath + "/namespace");
                    if (!destNamespaceId.canonical().equals(new String(nId, StandardCharsets.UTF_8)) || tableId.canonical().equals(tid)) continue;
                    throw new AcceptableThriftTableOperationException(tid, tableName, operation, TableOperationExceptionType.EXISTS, null);
                }
                catch (KeeperException.NoNodeException nne) {
                    log.trace("skipping tableId {}, either being created or has been deleted.", (Object)tid, (Object)nne);
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Error checking to see if tableId {} exists in ZooKeeper", (Object)tableId, (Object)e);
            throw new AcceptableThriftTableOperationException(null, tableName, TableOperation.CREATE, TableOperationExceptionType.OTHER, e.getMessage());
        }
    }

    public static <T extends AbstractId<T>> T getNextId(String name, ServerContext context, Function<String, T> newIdFunction) throws AcceptableThriftTableOperationException {
        try {
            ZooReaderWriter zoo = context.getZooReaderWriter();
            String ntp = context.getZooKeeperRoot() + "/tables";
            byte[] nid = zoo.mutateOrCreate(ntp, ZERO_BYTE, currentValue -> {
                BigInteger nextId = new BigInteger(new String(currentValue, StandardCharsets.UTF_8), 36);
                nextId = nextId.add(BigInteger.ONE);
                return nextId.toString(36).getBytes(StandardCharsets.UTF_8);
            });
            return (T)((AbstractId)newIdFunction.apply(new String(nid, StandardCharsets.UTF_8)));
        }
        catch (Exception e1) {
            log.error("Failed to assign id to " + name, (Throwable)e1);
            throw new AcceptableThriftTableOperationException(null, name, TableOperation.CREATE, TableOperationExceptionType.OTHER, e1.getMessage());
        }
    }

    public static long reserveTable(Manager env, TableId tableId, long tid, boolean writeLock, boolean tableMustExist, TableOperation op) throws Exception {
        if (Utils.getLock(env.getContext(), tableId, tid, writeLock).tryLock()) {
            ZooReaderWriter zk;
            if (tableMustExist && !(zk = env.getContext().getZooReaderWriter()).exists(env.getContext().getZooKeeperRoot() + "/tables/" + String.valueOf(tableId))) {
                throw new AcceptableThriftTableOperationException(tableId.canonical(), "", op, TableOperationExceptionType.NOTFOUND, "Table does not exist");
            }
            log.info("table {} {} locked for {} operation: {}", new Object[]{tableId, FateTxId.formatTid((long)tid), writeLock ? "write" : "read", op});
            return 0L;
        }
        return 100L;
    }

    public static void unreserveTable(Manager env, TableId tableId, long tid, boolean writeLock) {
        Utils.getLock(env.getContext(), tableId, tid, writeLock).unlock();
        log.info("table {} {} unlocked for {}", new Object[]{tableId, FateTxId.formatTid((long)tid), writeLock ? "write" : "read"});
    }

    public static void unreserveNamespace(Manager env, NamespaceId namespaceId, long id, boolean writeLock) {
        Utils.getLock(env.getContext(), namespaceId, id, writeLock).unlock();
        log.info("namespace {} {} unlocked for {}", new Object[]{namespaceId, FateTxId.formatTid((long)id), writeLock ? "write" : "read"});
    }

    public static long reserveNamespace(Manager env, NamespaceId namespaceId, long id, boolean writeLock, boolean mustExist, TableOperation op) throws Exception {
        if (Utils.getLock(env.getContext(), namespaceId, id, writeLock).tryLock()) {
            ZooReaderWriter zk;
            if (mustExist && !(zk = env.getContext().getZooReaderWriter()).exists(env.getContext().getZooKeeperRoot() + "/namespaces/" + String.valueOf(namespaceId))) {
                throw new AcceptableThriftTableOperationException(namespaceId.canonical(), "", op, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace does not exist");
            }
            log.info("namespace {} {} locked for {} operation: {}", new Object[]{namespaceId, FateTxId.formatTid((long)id), writeLock ? "write" : "read", op});
            return 0L;
        }
        return 100L;
    }

    public static long reserveHdfsDirectory(Manager env, String directory, long tid) throws KeeperException, InterruptedException {
        String resvPath = env.getContext().getZooKeeperRoot() + "/hdfs_reservations/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReaderWriter zk = env.getContext().getZooReaderWriter();
        if (ZooReservation.attempt((ZooReaderWriter)zk, (String)resvPath, (String)FastFormat.toHexString((long)tid), (String)"")) {
            return 0L;
        }
        return 50L;
    }

    public static void unreserveHdfsDirectory(Manager env, String directory, long tid) throws KeeperException, InterruptedException {
        String resvPath = env.getContext().getZooKeeperRoot() + "/hdfs_reservations/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReservation.release((ZooReaderWriter)env.getContext().getZooReaderWriter(), (String)resvPath, (String)FastFormat.toHexString((long)tid));
    }

    private static Lock getLock(ServerContext context, AbstractId<?> id, long tid, boolean writeLock) {
        byte[] lockData = FastFormat.toZeroPaddedHex((long)tid);
        FateLock.FateLockPath fLockPath = FateLock.path((String)(context.getZooKeeperRoot() + "/table_locks/" + id.canonical()));
        FateLock qlock = new FateLock(context.getZooReaderWriter(), fLockPath);
        Lock lock = DistributedReadWriteLock.recoverLock((DistributedReadWriteLock.QueueLock)qlock, (byte[])lockData);
        if (lock == null) {
            DistributedReadWriteLock locker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)qlock, lockData);
            lock = writeLock ? locker.writeLock() : locker.readLock();
        }
        return lock;
    }

    public static Lock getIdLock() {
        return idLock;
    }

    public static Lock getTableNameLock() {
        return tableNameLock;
    }

    public static Lock getReadLock(Manager env, AbstractId<?> id, long tid) {
        return Utils.getLock(env.getContext(), id, tid, false);
    }

    public static void checkNamespaceDoesNotExist(ServerContext context, String namespace, NamespaceId namespaceId, TableOperation operation) throws AcceptableThriftTableOperationException {
        NamespaceId n = Namespaces.lookupNamespaceId((ClientContext)context, (String)namespace);
        if (n != null && !n.equals((Object)namespaceId)) {
            throw new AcceptableThriftTableOperationException(null, namespace, operation, TableOperationExceptionType.NAMESPACE_EXISTS, null);
        }
    }

    public static SortedSet<Text> getSortedSetFromFile(Manager manager, Path path, boolean encoded) throws IOException {
        FileSystem fs = path.getFileSystem(manager.getContext().getHadoopConf());
        TreeSet<Text> data = new TreeSet<Text>();
        try (Scanner file = new Scanner((InputStream)fs.open(path), StandardCharsets.UTF_8);){
            while (file.hasNextLine()) {
                String line = file.nextLine();
                data.add(encoded ? new Text(Base64.getDecoder().decode(line)) : new Text(line));
            }
        }
        return data;
    }
}

