/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.util.Timer;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedBatchWriter {
    private static final Logger log = LoggerFactory.getLogger(SharedBatchWriter.class);
    private final Character prefix;
    private final BlockingQueue<Work> mutations;
    private final String table;
    private final ServerContext context;

    public SharedBatchWriter(String table, Character prefix, ServerContext context, int queueSize) {
        Preconditions.checkArgument((queueSize > 0 ? 1 : 0) != 0, (String)"illegal queue size %s", (int)queueSize);
        this.table = table;
        this.prefix = prefix;
        this.context = context;
        this.mutations = new ArrayBlockingQueue<Work>(queueSize);
        Thread thread = Threads.createCriticalThread((String)("shared batch writer for " + table + " prefix:" + prefix), this::processMutations);
        thread.start();
    }

    public void write(Mutation m) {
        try {
            Work work = new Work(m);
            this.mutations.put(work);
            work.future.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private void processMutations() {
        Timer timer = Timer.startNew();
        while (true) {
            ArrayList<Work> batch = new ArrayList<Work>();
            try {
                batch.add(this.mutations.take());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
            try {
                BatchWriter writer = this.context.createBatchWriter(this.table);
                try {
                    this.mutations.drainTo(batch);
                    timer.restart();
                    for (Work work2 : batch) {
                        writer.addMutation(work2.mutation);
                    }
                    writer.flush();
                    log.trace("Wrote {} mutations in {}ms for prefix {}", new Object[]{batch.size(), timer.elapsed(TimeUnit.MILLISECONDS), this.prefix});
                    batch.forEach(work -> work.future.complete(null));
                    continue;
                }
                finally {
                    if (writer == null) continue;
                    writer.close();
                    continue;
                }
            }
            catch (MutationsRejectedException | TableNotFoundException e) {
                log.debug("Failed to process {} mutations in {}ms for prefix {}", new Object[]{batch.size(), timer.elapsed(TimeUnit.MILLISECONDS), this.prefix, e});
                batch.forEach(arg_0 -> SharedBatchWriter.lambda$processMutations$1((Exception)e, arg_0));
                continue;
            }
            break;
        }
    }

    private static /* synthetic */ void lambda$processMutations$1(Exception e, Work work) {
        work.future.completeExceptionally(e);
    }

    private static class Work {
        private final Mutation mutation;
        private final CompletableFuture<Void> future;

        private Work(Mutation mutation) {
            this.mutation = mutation;
            this.future = new CompletableFuture();
        }
    }
}

