This file is part of the c2cweb package Version 1.5

This is a change file for CWEB's CWEAVE (Ver. 3.4g June 1996)

modified by Werner Lemberg (a7971428@@unet.univie.ac.at) 10-Nov-1996

===============================================================================

An exclamation mark (!) removes a bug in the original CWEAVE which caused
unbalanced braces sometimes.

One star (*) marks changes of the productions if switch a is set --
please look at an output to see what. Additionally cwebmaca.tex will be used
by TeX instead of cwebmac.tex .

Two stars (**) mark changes to the index routines: function definitions will
now have () after the identifier if the i switch is on (this will work properly
only if you don't have function names identical to names of variables,
structures etc.).

Three stars (***) change the debugging output slightly.

A (+) enables the dollar sign `$' in identifiers; some compilers allow it,
and it doesn't harm in the output.

Two plus (++) improve the processing of #define statements (weird things
like '#define short int'). Two new control codes are introduced: @{ and @}
(i.e. invisible braces). You will need this if you have unbalanced braces due
to #ifdef ... #endif statements. The concatenation operator ## will be now
recognized.

Three plus (+++) implement exotic cases of C++ (look e.g. for "iostream.h").


These changes are not perfect yet; if you don't like some things, remove the
specified sections. (Or better, improve them and send the new change file(s)
to me :-)


@x in limbo
\let\maybe=\iftrue
@y
\let\maybe=\iffalse
@z

@x section 1
@d banner "This is CWEAVE (Version 3.4)\n"
@y
@d banner "This is CWEAVE (Version 3.4) modified by Werner Lemberg (V1.5)\n"
@z

@x section 4
@d max_bytes 90000 /* the number of bytes in identifiers,
  index entries, and section names */
@d max_names 4000 /* number of identifiers, strings, section names;
  must be less than 10240; used in |"common.w"| */
@d max_sections 2000 /* greater than the total number of sections */
@d hash_size 353 /* should be prime */
@d buf_size 100 /* maximum length of input line, plus one */
@d longest_name 1000 /* section names and strings shouldn't be longer than this */
@d long_buf_size (buf_size+longest_name)
@d line_length 80 /* lines of \TEX/ output have at most this many characters;
  should be less than 256 */
@d max_refs 20000 /* number of cross-references; must be less than 65536 */
@d max_toks 20000 /* number of symbols in \CEE/ texts being parsed;
  must be less than 65536 */
@d max_texts 4000 /* number of phrases in \CEE/ texts being parsed;
  must be less than 10240 */
@d max_scraps 2000 /* number of tokens in \CEE/ texts being parsed */
@d stack_size 400 /* number of simultaneous output levels */
@y
@d max_bytes 225000 /* the number of bytes in identifiers,
  index entries, and section names */
@d max_names 10000 /* number of identifiers, strings, section names;
  must be less than 10240; used in |"common.w"| */
@d max_sections 2000 /* greater than the total number of sections */
@d hash_size 353 /* should be prime */
@d buf_size 400 /* maximum length of input line, plus one */
@d longest_name 1000 /* section names and strings shouldn't be longer than this */
@d long_buf_size (buf_size+longest_name)
@d line_length 100 /* lines of \TEX/ output have at most this many characters;
  should be less than 256 */
@d max_refs 20000 /* number of cross-references; must be less than 65536 */
@d max_toks 65000 /* number of symbols in \CEE/ texts being parsed;
  must be less than 65536 */
@d max_texts 10200 /* number of phrases in \CEE/ texts being parsed;
  must be less than 10240 */
@d max_scraps 65000 /* number of tokens in \CEE/ texts being parsed */
@d stack_size 10000 /* number of simultaneous output levels */
@z

**

@x section 16
@d ilk dummy.Ilk
@y
@d ilk dummy.dummy1.Ilk
@d func_flag dummy.dummy1.Func_flag
@z

++

@x section 30
@d new_section 0231 /* control code for `\.{@@\ }' and `\.{@@*}' */
@y
@d new_section 0231 /* control code for `\.{@@\ }' and `\.{@@*}' */
@d pseudo_lbrace 022 /* control code for `\.{@@\{}' */
@d pseudo_rbrace 023 /* control code for `\.{@@\}}' */
@z

++

@x section 32
ccode['+']=no_line_break; ccode[';']=pseudo_semi;
ccode['[']=macro_arg_open; ccode[']']=macro_arg_close;
@y
ccode['+']=no_line_break; ccode[';']=pseudo_semi;
ccode['{']=pseudo_lbrace; ccode['}']=pseudo_rbrace;
ccode['[']=macro_arg_open; ccode[']']=macro_arg_close;
@z

+

@x section 39
@d isxalpha(c) ((c)=='_') /* non-alpha character allowed in identifier */
@y
@d isxalpha(c) ((c)=='_' || (c)=='$')
                          /* non-alpha characters allowed in identifier */
@z

++

@x section 40
eight_bits
get_next() /* produces the next input token */
{@+eight_bits c; /* the current character */
  while (1) {
    @<Check if we're at the end of a preprocessor command@>;
    if (loc>limit && get_line()==0) return(new_section);
    c=*(loc++);
    if (xisdigit(c) || c=='\\' || c=='.') @<Get a constant@>@;
    else if (c=='\'' || c=='"' || (c=='L'&&(*loc=='\'' || *loc=='"'))@|
           || (c=='<' && sharp_include_line==1))
        @<Get a string@>@;
    else if (xisalpha(c) || isxalpha(c) || ishigh(c))
      @<Get an identifier@>@;
    else if (c=='@@') @<Get control code and possible section name@>@;
    else if (xisspace(c)) continue; /* ignore spaces and tabs */
    if (c=='#' && loc==buffer+1) @<Raise preprocessor flag@>;
    mistake: @<Compress two-symbol operator@>@;
    return(c);
  }
}
@y
eight_bits
get_next() /* produces the next input token */
{@+eight_bits c; /* the current character */
   int blank_count=0; /* number of leading blanks */

  if (loc<limit && preprocessing && (define_pos==2 || define_pos==4) &&
      xisspace(*loc)) {
    define_pos=5;
    return(preproc_space);
  }

  while (1) {
    @<Check if we're at the end of a preprocessor command@>;
    if (loc>limit && get_line()==0) return(new_section);

    if(loc==buffer) {
      blank_count=0;
      while((*loc==' ' || *loc=='\t') && loc<limit) {
        blank_count++; loc++;
      }
    }

    c=*(loc++);
    if (xisdigit(c) || c=='\\' || c=='.') @<Get a constant@>@;
    else if (c=='\'' || c=='"' || (c=='L'&&(*loc=='\'' || *loc=='"'))@|
           || (c=='<' && sharp_include_line==1))
        @<Get a string@>@;
    else if (xisalpha(c) || isxalpha(c) || ishigh(c))
      @<Get an identifier@>@;
    else if (c=='@@') @<Get control code and possible section name@>@;
    else if (xisspace(c)) continue; /* ignore spaces and tabs */
    if (c=='#' && loc==buffer+1+blank_count && !preprocessing)
      @<Raise preprocessor flag@>;
    mistake: @<Compress two-symbol operator@>@;
    if(preprocessing) {
      if (c=='(' && define_pos==2 && !xisspace(*(loc-2)))
        define_pos=3;
      else if (c==')' && define_pos==3)
        define_pos=4;
      }
    return(c);
  }
}
@z

++

@x section 41
@d left_preproc ord /* begins a preprocessor command */
@d right_preproc 0217 /* ends a preprocessor command */

@<Glob...@>=
boolean preprocessing=0; /* are we scanning a preprocessor command? */
@y
@d left_preproc ord /* begins a preprocessor command */
@d right_preproc 0217 /* ends a preprocessor command */
@d preproc_space '\b' /* emitted before the macro sustitution */
@d numb_numb '\f' /* `\.{\#\#}'\,; the concatenation operator */

@<Glob...@>=
boolean preprocessing=0; /* are we scanning a preprocessor command? */
int define_pos=0;
               /* at which position we are while scanning a macro definition */
@z

++

@x section 45
  if (loc>=limit && preprocessing) {
    preprocessing=sharp_include_line=0;
    return(right_preproc);
  }
@y
  if (loc>=limit && preprocessing) {
    preprocessing=sharp_include_line=define_pos=0;
    return(right_preproc);
  }
@z

++

@x section 46
  case '!': if (*loc=='=') compress(not_eq); break;
@y
  case '!': if (*loc=='=') compress(not_eq); break;
  case '#': if (*loc=='#') compress(numb_numb); break;
@z

++

@x section 47
  id_first=--loc;
  while (isalpha(*++loc) || isdigit(*loc) || isxalpha(*loc) || ishigh(*loc));
  id_loc=loc; return(identifier);
@y
  id_first=--loc;

  if (preprocessing) {
    if (define_pos==1)
      define_pos=2;
    else if (strncmp(loc, "define", 6)==0 && xisspace(*(loc+6)))
      define_pos=1;
  }

  while (isalpha(*++loc) || isdigit(*loc) || isxalpha(*loc) || ishigh(*loc));
  id_loc=loc; return(identifier);
@z

!

@x section 77
int out_line; /* number of next line to be output */
@y
int out_line; /* number of next line to be output */

boolean in_math = 0;
boolean escape = 0;
int math_brace_count = 0;
@z

*

@x section 80
out_ptr=out_buf+1; out_line=1; active_file=tex_file;
*out_ptr='c'; tex_printf("\\input cwebma");
@y
out_ptr=out_buf+1; out_line=1; active_file=tex_file;
if(alternative) {
  *out_ptr='a';
  tex_printf("\\input cwebmac");
} else {
  *out_ptr='c';
  tex_printf("\\input cwebma");
}
@z

!

@x section 81
@d out(c) {if (out_ptr>=out_buf_end) break_out(); *(++out_ptr)=c;}

@c
@y
@c
void
out(c)
char c;
{
    if (out_ptr >= out_buf_end)
        break_out();

    if(!escape) {
        if(in_math) {
            if(c == '{')
                math_brace_count++;
            else if(c == '}') {
                math_brace_count--;
                if(math_brace_count < 0) {
                    math_brace_count = 0;
                    return;
                }
            }
        }
        if(c == '$') {
            while(math_brace_count > 0) {
                *(++out_ptr) = '}';
                math_brace_count--;
            }
            in_math = 1 - in_math;
        }
    }

    if(c == '\\' && !escape)
        escape = 1;
    else
        escape = 0;

    *(++out_ptr) = c;
    return;
}
@z

*

@x section 97
@d tag 29 /* denotes a statement label */
@y
@d tag 29
   /* denotes a statement label (if |alternative| is set, only a case label) */
@z

*, ++

@x section 97
@d end_arg 59 /* \.{@@]} */
@y
@d end_arg 59 /* \.{@@]} */
@d label 60  /* denotes a label; used if |alternative| is set */
@d do_head 61 /* used if |alternative| is set */
@d pp_space 62 /* denotes the start point of a macro replacement text */
@z

*, ++

@x section 98
    strcpy(cat_name[end_arg],@q[@>"@@]");
@y
    strcpy(cat_name[end_arg],@q[@>"@@]");
    strcpy(cat_name[label],"label"); /* used if |alternative| is set */
    strcpy(cat_name[do_head], "do_head"); /* used if |alternative| is set */
    strcpy(cat_name[pp_space], "#_");
@z

++ section 101

@x
\.:&|colon|: \.:&maybe\cr
\.\# (within line)&|unorbinop|: \.{\\\#}&yes\cr
@y
\.:&|colon|: \.:&maybe\cr
\.{\#\#}&|binop|: \.{\\NN}&yes\cr
\.\# (within line)&|unorbinop|: \.{\\\#}&yes\cr
@z

*

@x section 101
@i prod.w
@y
@i prod-alt.w
@z

*

@x section 110
    case raw_int: @<Cases for |raw_int|@>; @+break;
@y
    case raw_int: @<Cases for |raw_int|@>; @+break;
    case label: @<Cases for |label|@>; @+break;
    case do_head: @<Cases for |do_head|@>; @+break;
@z

++

@x section 112
void
make_reserved(p) /* make the first identifier in |p->trans| like |int| */
scrap_pointer p;
{
  sixteen_bits tok_value; /* the name of this identifier, plus its flag*/
  token_pointer tok_loc; /* pointer to |tok_value| */
  if ((tok_loc=find_first_ident(p->trans))==no_ident_found)
    return; /* this should not happen */
  tok_value=*tok_loc;
  for (;p<=scrap_ptr; p==lo_ptr? p=hi_ptr: p++) {
    if (p->cat==exp) {
      if (**(p->trans)==tok_value) {
        p->cat=raw_int;
        **(p->trans)=tok_value%id_flag+res_flag;
      }
    }
  }
  (name_dir+(sixteen_bits)(tok_value%id_flag))->ilk=raw_int;
  *tok_loc=tok_value%id_flag+res_flag;
}
@y
void
make_reserved(p, cat) /* make the first identifier in |p->trans| like |cat| */
scrap_pointer p;
eight_bits cat;
{
  sixteen_bits tok_value; /* the name of this identifier, plus its flag*/
  token_pointer tok_loc; /* pointer to |tok_value| */
  if ((tok_loc=find_first_ident(p->trans))==no_ident_found)
    return; /* this should not happen */
  tok_value=*tok_loc;
  for (;p<=scrap_ptr; p==lo_ptr? p=hi_ptr: p++) {
    if (p->cat==exp || p->cat==int_like || p->cat==const_like) {
      if (**(p->trans)==tok_value) {
        p->cat=cat;
        **(p->trans)=tok_value%id_flag+res_flag;
      }
    }
  }
  (name_dir+(sixteen_bits)(tok_value%id_flag))->ilk=cat;
  *tok_loc=tok_value%id_flag+res_flag;
}
@z

*

@x section 117
  make_underlined (pp);  squash(pp,2,tag,0,7);
@y
  make_underlined (pp);
  if(alternative)
    squash(pp,2,label,0,7);
  else
    squash(pp,2,tag,0,7);
@z

+++

@x section 125
  else squash(pp,2,int_like,-2,32);
}
@y
  else squash(pp,2,int_like,-2,32);
}
else if (cat1==binop && cat2==exp) squash(pp,3,int_like,-2,117);
@z

++

@x section 128
if (cat1==decl_head)
  if ((cat2==exp&&cat3!=lpar&&cat3!=exp)||cat2==int_like) {
    make_underlined(pp+2); make_reserved(pp+2);
    big_app2(pp+1); reduce(pp+1,2,decl_head,0,42);
  }
  else if (cat2==semi) {
    big_app1(pp); big_app(' '); big_app2(pp+1); reduce(pp,3,decl,-1,43);
  }
@y
if (cat1==decl_head) {
  if ((cat2==exp&&cat3!=lpar&&cat3!=exp)||cat2==int_like) {
    make_underlined(pp+2); make_reserved(pp+2, raw_int);
    big_app2(pp+1); reduce(pp+1,2,decl_head,0,42);
  }
  else if (cat2==semi) {
    big_app1(pp); big_app(' '); big_app2(pp+1); reduce(pp,3,decl,-1,43);
  }
}
else if (cat1==exp && !preprocessing && cat2!=lpar) {
  make_reserved(pp+1, raw_int);
  squash(pp+1,1,raw_int,-2,116);
}
@z

*

@x section 129
if (cat1==lbrace) {
  big_app1(pp); big_app(' '); big_app1(pp+1); reduce(pp,2,struct_head,0,44);
}
else if (cat1==exp||cat1==int_like) {
  if (cat2==lbrace || cat2==semi) {
    make_underlined(pp+1); make_reserved(pp+1);
    big_app1(pp); big_app(' '); big_app1(pp+1);
    if (cat2==semi) reduce(pp,2,decl_head,0,45);
    else {
      big_app(' '); big_app1(pp+2);reduce(pp,3,struct_head,0,46);
    }
  }
  else if (cat2==colon) squash(pp+2,1,base,-1,47);
  else if (cat2!=base) {
    big_app1(pp); big_app(' '); big_app1(pp+1); reduce(pp,2,int_like,-2,48);
  }
}
@y
if (cat1==lbrace) {
  if(alternative) {
    big_app1(pp); big_app(indent); big_app(force); big_app(backup);
    big_app1(pp+1); reduce(pp,2,struct_head,0,44);
  } else {
    big_app1(pp); big_app(' '); big_app1(pp+1);
    reduce(pp,2,struct_head,0,44);
  }
}
else if (cat1==exp||cat1==int_like) {
  if (cat2==lbrace || cat2==semi) {
    make_underlined(pp+1); make_reserved(pp+1, raw_int);
    big_app1(pp); big_app(' '); big_app1(pp+1);
    if (cat2==semi) reduce(pp,2,decl_head,-1,45);
    else {
      if(alternative) {
        big_app(indent); big_app(force); big_app(backup); big_app1(pp+2);
        reduce(pp,3,struct_head,0,46);
      } else {
        big_app(' '); big_app1(pp+2); reduce(pp,3,struct_head,0,46);
      }
    }
  }
  else if (cat2==colon) squash(pp+2,1,base,-1,47);
  else if (!(cat2==base || cat2==raw_int ||
           cat2==int_like || cat2==const_like)) {
    big_app1(pp); big_app(' '); big_app1(pp+1); reduce(pp,2,int_like,-2,48);
  }
}
@z

*

@x section 130
  big_app1(pp); big_app(indent); big_app(force); big_app1(pp+1);
  big_app(outdent); big_app(force);  big_app1(pp+2);
  reduce(pp,3,int_like,-2,49);
@y
  if(alternative) {
    big_app1(pp); big_app1(pp+1);
    big_app(force); big_app(backup); big_app1(pp+2); big_app(' ');
    big_app(outdent); reduce(pp,3,int_like,-2,49);
  } else {
    big_app1(pp); big_app(indent); big_app(force); big_app1(pp+1);
    big_app(outdent); big_app(force); big_app1(pp+2);
    reduce(pp,3,int_like,-2,49);
  }
@z

*

@x section 133
  big_app(force); big_app1(pp);  big_app(indent); big_app(force);
  big_app1(pp+1); big_app(force); big_app(backup);  big_app1(pp+2);
  big_app(outdent); big_app(force); reduce(pp,3,stmt,-1,55);
@y
  if(alternative) {
    big_app(indent); big_app(force); big_app(backup); big_app1(pp);
    app(noop); big_app(cancel); big_app1(pp+1); big_app(force); big_app(backup);
    big_app1(pp+2); big_app(outdent); big_app(force); reduce(pp,3,stmt,-2,55);
  } else {
    big_app(force); big_app1(pp);  big_app(indent); big_app(force);
    big_app1(pp+1); big_app(force); big_app(backup);  big_app1(pp+2);
    big_app(outdent); big_app(force); reduce(pp,3,stmt,-1,55);
  }
@z

*

@x section 136
  big_app(force); big_app1(pp); big_app(indent); big_app(break_space);
  big_app1(pp+1); big_app(outdent); big_app(force);
  reduce(pp,2,stmt,-1,60);
@y
  if(alternative) {
    big_app(force); big_app1(pp); big_app(indent); big_app(force);
    big_app1(pp+1); big_app(outdent); big_app(force);
    reduce(pp,2,stmt,-1,60);
  } else {
    big_app(force); big_app1(pp); big_app(indent); big_app(break_space);
    big_app1(pp+1); big_app(outdent); big_app(force);
    reduce(pp,2,stmt,-1,60);
  }
@z

*

@x section 137
  big_app(force); big_app1(pp); big_app(break_space); app(noop);
  big_app(cancel); big_app1(pp+1); big_app(force);
  reduce(pp,2,stmt,-1,61);
@y
  if(alternative) {
    big_app(force); big_app1(pp); big_app(break_space);
    big_app1(pp+1); big_app(force);
    reduce(pp,2,stmt,-1,61);
  } else {
    big_app(force); big_app1(pp); big_app(break_space); app(noop);
    big_app(cancel); big_app1(pp+1); big_app(force);
    reduce(pp,2,stmt,-1,61);
  }
@z

*

@x section 138
    big_app(force); big_app1(pp); big_app(indent); big_app(break_space);
    big_app1(pp+1); big_app(outdent); big_app(force); big_app1(pp+2);
    if (cat3==if_like) {
      big_app(' '); big_app1(pp+3); reduce(pp,4,if_like,0,63);
    }@+else reduce(pp,3,else_like,0,64);
@y
    if(alternative) {
      big_app(force); big_app1(pp); big_app(indent); big_app(force);
      big_app1(pp+1); big_app(outdent); big_app(force); big_app1(pp+2);
    } else {
      big_app(force); big_app1(pp); big_app(indent); big_app(break_space);
      big_app1(pp+1); big_app(outdent); big_app(force); big_app1(pp+2);
    }
    if (cat3==if_like) {
      big_app(' '); big_app1(pp+3); reduce(pp,4,if_like,0,63);
    }@+else reduce(pp,3,else_like,0,64);
@z

*

@x section 139
    big_app(force); big_app1(pp); big_app(break_space); app(noop);
    big_app(cancel); big_app1(pp+1); big_app(force); big_app1(pp+2);
    if (cat3==if_like) {
      big_app(' '); big_app1(pp+3); reduce(pp,4,if_like,0,66);
    }@+else reduce(pp,3,else_like,0,67);
@y
    if(alternative) {
      big_app(force); big_app1(pp); big_app(break_space);
      big_app1(pp+1); big_app(force); big_app1(pp+2);
    } else {
      big_app(force); big_app1(pp); big_app(break_space); app(noop);
      big_app(cancel); big_app1(pp+1); big_app(force); big_app1(pp+2);
    }
    if (cat3==if_like) {
      big_app(' '); big_app1(pp+3); reduce(pp,4,if_like,0,66);
    }@+else reduce(pp,3,else_like,0,67);
@z

*

@x section 140
if (cat1==stmt && cat2==else_like && cat3==semi) {
  big_app1(pp); big_app(break_space); app(noop); big_app(cancel);
  big_app1(pp+1); big_app(cancel); app(noop); big_app(break_space);
  big_app2(pp+2); reduce(pp,4,stmt,-1,69);
}
@y
if(alternative) {
  if (cat1==lbrace) squash(pp,1,do_head,0,114);
  else if (cat1==stmt && cat2==else_like && cat3==semi) {
    big_app(force); big_app1(pp); big_app(indent); big_app(force);
    big_app1(pp+1); big_app(cancel); app(noop);
    big_app(break_space); big_app2(pp+2); big_app(outdent); big_app(force);
    reduce(pp,4,stmt,-1,69);
  }
} else {
  if (cat1==stmt && cat2==else_like && cat3==semi) {
    big_app1(pp); big_app(break_space); app(noop); big_app(cancel);
    big_app1(pp+1); big_app(cancel); app(noop); big_app(break_space);
    big_app2(pp+2); reduce(pp,4,stmt,-1,69);
  }
}
@z

*

@x section 141
if (cat1==semi) squash(pp,2,stmt,-1,70);
else if (cat1==colon) squash(pp,2,tag,-1,71);
@y
if (cat1==semi) squash(pp,2,stmt,-3,70);
else if (cat1==colon) squash(pp,2,tag,-2,71);
@z

*

@x section 141
    reduce(pp,3,tag,-1,73);
@y
    reduce(pp,3,tag,-2,73);
@z

*

@x section 142
if (cat1==tag) {
  big_app1(pp); big_app(break_space); big_app1(pp+1); reduce(pp,2,tag,-1,74);
}
else if (cat1==stmt||cat1==decl||cat1==function) {
  big_app(force); big_app(backup); big_app1(pp); big_app(break_space);
  big_app1(pp+1); reduce(pp,2,cat1,-1,75);
}
@y
if(alternative) {
  if (cat1==tag) {
    big_app1(pp); big_app(force); big_app1(pp+1); reduce(pp,2,tag,-1,74);
  }
  else if ((cat1==stmt||cat1==decl||cat1==function) &&
           (cat2==rbrace||cat2==tag)) {
    big_app(force); big_app1(pp); big_app(indent); big_app(force);
    big_app1(pp+1); big_app(outdent); reduce(pp,2,cat1,-1,75);
  }
} else {
  if (cat1==tag) {
    big_app1(pp); big_app(break_space); big_app1(pp+1); reduce(pp,2,tag,-1,74);
  }
  else if (cat1==stmt||cat1==decl||cat1==function) {
    big_app(force); big_app(backup); big_app1(pp); big_app(break_space);
    big_app1(pp+1); reduce(pp,2,cat1,-1,75);
  }
}
@z

++

@x section 145
} else if (cat1==exp || cat1==function) {
  if (cat2==rproc) {
    app(inserted); big_app1(pp); big_app(' '); big_app2(pp+1);
    reduce(pp,3,insert,-1,80);
  }
  else if (cat2==exp && cat3==rproc && cat1==exp) {
    app(inserted); big_app1(pp); big_app(' '); big_app1(pp+1); app_str(" \\5");
@.\\5@>
    big_app2(pp+2); reduce(pp,4,insert,-1,80);
  }
}
@y
} else if ((cat1==exp || cat1==function || cat1==int_like) && cat2==rproc) {
    app(inserted); big_app1(pp); big_app(' '); big_app2(pp+1);
    reduce(pp,3,insert,-1,80);
} else if ((cat1==exp || cat1==int_like || cat1==const_like) &&
            cat2==pp_space) {
    if(cat3==int_like || cat3==const_like || cat3==raw_int)
      make_reserved(pp+1, (pp+3)->cat);
    big_app1(pp); big_app(' '); big_app1(pp+1); app_str(" \\5");
@.\\5@>
    reduce(pp,3,lproc,-1,119);
} else if (cat1==exp && cat2==exp && cat3==pp_space) {
    big_app1(pp); big_app(' '); big_app2(pp+1); app_str(" \\5");
    reduce(pp,4,lproc,-1,120);
}
@z

*

@x section 151
if (cat1==colon) squash(pp,2,tag,-1,90);
@y
if (cat1==colon) squash(pp,2,tag,-2,90);
@z

+++

@x section 154
if (cat1==binop || cat1==unop || cat1==unorbinop) {
  if (cat2==binop) break;
  big_app1(pp); big_app('{'); big_app1(pp+1); big_app('}');
  reduce(pp,2,exp,-2,97);
}
else if (cat1==new_like || cat1==sizeof_like) {
  big_app1(pp); big_app(' '); big_app1(pp+1); reduce(pp,2,exp,-2,98);
}
@y
if (cat1==binop || cat1==unop || cat1==unorbinop || cat1==raw_unorbin) {
  if (cat2==binop) break;
  big_app1(pp); big_app('{'); big_app1(pp+1); big_app('}');
  reduce(pp,2,exp,-2,97);
}
else if (cat1==new_like || cat1==sizeof_like) {
  big_app1(pp); big_app(' '); big_app1(pp+1); reduce(pp,2,exp,-2,98);
}
else if (cat1==raw_int || cat1==int_like || cat1==const_like) {
  big_app1(pp); big_app(' '); big_app1(pp+1);
  reduce(pp,2,operator_like,-2,118);
}
@z

*** This makes the tracing info looking smoother

@x section 168
  if (tracing==2) {
    printf("\n%d:",n);
@y
  if (tracing==2) {
    printf("\n%3d:",n);
@z

**, ++

@x section 175
@ @<Append the scr...@>=
@<Make sure that there is room for the new scraps, tokens, and texts@>;
@y
@
@d alternative flags['a'] /* if set, an alternative format is produced */
@d func_index flags['i']
                        /* should functions in the index have |()| appended? */

@<Append the scr...@>=
@<Make sure that there is room for the new scraps, tokens, and texts@>;
@z

*, **

@x section 175
  case '(': case '[': app(next_control); app_scrap(lpar,maybe_math);@+break;
  case ')': case ']': app(next_control); app_scrap(raw_rpar,maybe_math);@+break;
  case '{': app_str("\\{"@q}@>); app_scrap(lbrace,yes_math);@+break;
@.\\\{@>@q}@>
  case '}': app_str(@q{@>"\\}"); app_scrap(rbrace,yes_math);@+break;
@q{@>@.\\\}@>
@y
  case '(': if(func_index)
              if(*(tok_ptr-1)>=id_flag && *(tok_ptr-1)<res_flag)
                                                           /* an identifier? */
                (name_dir+ *(tok_ptr-1)%10240)->func_flag=1;
  case '[': app(next_control); app_scrap(lpar,maybe_math);@+break;
  case ')': case ']': app(next_control); app_scrap(raw_rpar,maybe_math);@+break;
  case '{': if(alternative)
              app_str("\\LBR");
            else
              app_str("\\{"@q}@>);
            app_scrap(lbrace,yes_math);@+break;
@.\\\{@>@q}@>
  case '}': if(alternative)
              app_str("\\RBR");
            else
              app_str(@q{@>"\\}");
            app_scrap(rbrace,yes_math);@+break;
@q{@>@.\\\}@>
@z

++

@x section 175
  case left_preproc: app(force); app(preproc_line);
    app_str("\\#"); app_scrap(lproc,no_math);@+break;
@.\\\#@>
  case right_preproc: app(force); app_scrap(rproc,no_math);@+break;
@y
  case left_preproc: app(force); app(preproc_line);
    app_str("\\#"); app_scrap(lproc,no_math);@+break;
@.\\\#@>
  case preproc_space: app(' '); app_scrap(pp_space, maybe_math);@+break;
  case right_preproc: app(force); app_scrap(rproc,no_math);@+break;
@z

++

@x section 175
  case pseudo_semi: app_scrap(semi,maybe_math);@+break;
@y
  case pseudo_semi: app_scrap(semi,maybe_math);@+break;
  case pseudo_lbrace: app_str("\\phantom{");
                      if(alternative)
                        app_str("\\LBR");
                      else
                        app_str("\\{"@q}@>);
                      app_str("}");
                      app_scrap(lbrace,yes_math);
                      break;
  case pseudo_rbrace: app_str("\\phantom{");
                      if(alternative)
                        app_str("\\RBR");
                      else
                        app_str(@q{@>"\\}");
                      app_str("}");
                      app_scrap(rbrace,yes_math);
                      break;
@z

++

@x section 177
case minus_gt_ast: app_str("\\MGA");@+app_scrap(binop,yes_math);@+break;
@.\\MGA@>
@y
case minus_gt_ast: app_str("\\MGA");@+app_scrap(binop,yes_math);@+break;
@.\\MGA@>
case numb_numb: app_str("\\NN");@+app_scrap(binop,yes_math);@+break;
@.\\NN@>
@z

**

@x section 178
@.\\\%@>
@.\\\$@>
@.\\\^@>
@y
@.\\\%@>
@.\\$@>  @q CWEAVE quotes a dollar sign! @>
@.\\\^@>
@z

!

@x section 195
  } else if (is_tiny(cur_name)) out('|')
@y
  } else if (is_tiny(cur_name)) out('|');
@z

!

@x section 195
else out('&') /* |a==res_word| */
@y
else out('&'); /* |a==res_word| */
@z

!

@x section 196
      if (b!='0' || force_lines==0) out(b)@;
@y
      if (b!='0' || force_lines==0) out(b);
@z

**

@x section 200
@.\\\%@>
@.\\\$@>
@.\\\^@>
@y
@.\\\%@>
@.\\$@>  @q CWEAVE quotes a dollar symbol! @>
@.\\\^@>
@z

!

@x section 200
  else if (b!='|') out(b)
@y
  else if (b!='|') out(b);
@z

++

@x section 209
    case thin_space: case math_break: case ord:
    case line_break: case big_line_break: case no_line_break: case join:
    case pseudo_semi: case macro_arg_open: case macro_arg_close:
    case output_defs_code:
        err_print("! You can't do that in TeX text"); break;
@.You can't do that...@>
@y
    case thin_space: case math_break: case ord:
    case line_break: case big_line_break: case no_line_break: case join:
    case pseudo_semi: case macro_arg_open: case macro_arg_close:
    case pseudo_lbrace: case pseudo_rbrace:
    case output_defs_code:
        err_print("! You can't do that in TeX text"); break;
@.You can't do that...@>
@z

**

@x section 213
    if (*loc=='(')
  reswitch: switch (next_control=get_next()) {
      case '(': case ',': app(next_control); goto reswitch;
      case identifier: app_cur_id(0); goto reswitch;
      case ')': app(next_control); next_control=get_next(); break;
      default: err_print("! Improper macro definition"); break;
    }
@y
    if (*loc=='(') {
      if(func_index)
        (name_dir+ *(tok_ptr-1)%10240)->func_flag=1;
  reswitch: switch (next_control=get_next()) {
        case '(': case ',': app(next_control); goto reswitch;
        case identifier: app_cur_id(0); goto reswitch;
        case ')': app(next_control); next_control=get_next(); break;
        default: err_print("! Improper macro definition"); break;
      }
    }
@z

**

@x section 241
switch (cur_name->ilk) {
  case normal: if (is_tiny(cur_name)) out_str("\\|");
    else {char *j;
      for (j=cur_name->byte_start;j<(cur_name+1)->byte_start;j++)
        if (xislower(*j)) goto lowcase;
      out_str("\\."); break;
lowcase: out_str("\\\\");
    }
  break;
@.\\|@>
@.\\.@>
@.\\\\@>
  case roman: break;
  case wildcard: out_str("\\9"); break;
@.\\9@>
  case typewriter: out_str("\\."); break;
@.\\.@>
  case custom: case quoted: {char *j; out_str("$\\");
    for (j=cur_name->byte_start;j<(cur_name+1)->byte_start;j++)
      out(isxalpha(*j)? 'x' : *j);
    out('$');
    goto name_done;
    }
  default: out_str("\\&");
@.\\\&@>
}
out_name(cur_name);
name_done:
@y
switch (cur_name->ilk) {
  case normal:
    if (is_tiny(cur_name) && !cur_name->func_flag)
      out_str("\\|");
    else {char *j;
      for (j=cur_name->byte_start;j<(cur_name+1)->byte_start;j++)
        if (xislower(*j)) goto lowcase;
      out_str("\\."); break;
lowcase: out_str("\\\\");
    }
  break;
@.\\|@>
@.\\.@>
@.\\\\@>
  case roman: break;
  case wildcard: out_str("\\9"); break;
@.\\9@>
  case typewriter: out_str("\\."); break;
@.\\.@>
  case custom: case quoted: {char *j; out_str("$\\");
    for (j=cur_name->byte_start;j<(cur_name+1)->byte_start;j++)
      out(isxalpha(*j)? 'x' : *j);
    out('$');
    goto name_done;
    }
  default: out_str("\\&");
@.\\\&@>
}
out_name(cur_name);
name_done:
  if(cur_name->func_flag)
    out_str("(\\,)");
@z

*

@x section 249
@** Index.
@y
@ @<Cases for |label|@>=
if (cat1==label) {
  big_app1(pp); big_app(force); big_app1(pp+1); reduce(pp,2,label,-1,112);
}
else if (cat1==stmt||cat1==decl||cat1==function) {
  big_app(cancel); app(noop);
  big_app(outdent); big_app(outdent); big_app(force);
  big_app1(pp); big_app(indent); big_app(indent); big_app(force);
  big_app1(pp+1); reduce(pp,2,cat1,-1,113);
}

@ @<Cases for |do_head|@>=
if (cat1==stmt && cat2==else_like && cat3==semi) {
  big_app1(pp); big_app(break_space); big_app1(pp+1); big_app(cancel);
  app(noop); big_app(break_space); big_app2(pp+2); reduce(pp,4,stmt,-1,115);
}

@** Index.
@z

--- end of cweave.ch ---
