/* -*-C++-*-
 * ###################################################################
 *	Cpptcl - Integrating C++ with Tcl
 * 
 *	FILE: "cpptcl_init.h"
 *									  created: 30/5/96 {7:20:00 pm} 
 *								  last update: 17/12/97 {8:12:43 pm}	
 *	Author:	Vince Darley
 *	E-mail:	<mailto:darley@fas.harvard.edu>
 *	  mail:	Division of	Applied	Sciences, Harvard University
 *			Oxford Street, Cambridge MA	02138, USA
 *	   www: <http://www.fas.harvard.edu/~darley/>
 *	
 * ===================================================================
 * Copyright (c) 1997  Vince Darley
 *  
 * See the file "license.terms" for information on usage and 
 * redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 * ===================================================================
 *	Description: 
 * 
 * 
 *	History
 * 
 *	modified by	 rev reason
 *	-------- --- --- -----------
 *	18/12/95 VMD 1.0 original
 * ###################################################################
 */

#ifndef _Cpptcl_cpptcl_init_
#define _Cpptcl_cpptcl_init_

#include "tcl_obj.h"
//@Section: Cpptcl library
///
/** 
 * -------------------------------------------------------------------------
 *   
 * "cpptcl_create_stream" --
 *  
 *  Call this function from your Package_Init() procedure with the current 
 *  interpreter as an argument, and you'll receive that same interpreter 
 *  back, packaged up inside a tcl_obj.  It is up to the caller to delete 
 *  that stream at some future time.
 *  
 *  This procedure has now been enhanced to keep a record of 
 *  tcl_objs which have been created, and if there's a repeat request
 *  to return a reference to an old stream.  This will help to conserve
 *  memory.
 *  
 * --Version--Author------------------Changes-------------------------------  
 *    1.0     <darley@fas.harvard.edu> original
 * -------------------------------------------------------------------------
 */
tcl_obj& cpptcl_create_stream(Tcl_Interp*);

class tcl_interaction;
class meta_object;
class tcl_base;

int Cpptcl_CreatedNewObject(tcl_obj& tcl, class tcl_base *o);
int Cpptcl_DeletedObject(class tcl_base *o);
bool Cpptcl_UpdatedObject(tcl_base *update);

tcl_interaction* Cpptcl_ConvertToObject(Tcl_Interp* interp, Tcl_Obj* obj);
tcl_interaction* Cpptcl_ConvertToTypedObject(Tcl_Interp* interp, 
	Tcl_Obj* obj, const meta_object* type);

template <class T> bool Cpptcl(Tcl_Obj* obj,T*& w, Tcl_Interp* interp=0);

template <class T>
inline bool Cpptcl(Tcl_Obj* obj,T*& w, Tcl_Interp* interp=0) {
	return ((w = (T*) Cpptcl_ConvertToTypedObject(interp,obj,&T::_type)) != 0 ? true : false);
}


#endif
