-- File: tkz_elements_regular_polygon.lua
-- Copyright (c) 2026 Alain Matthes
-- SPDX-License-Identifier: LPPL-1.3c
-- Maintainer: Alain Matthes


regular_polygon = {}
regular_polygon.__index = regular_polygon
function regular_polygon:new(za, zb, nb)
	if nb < 3 then
		tex.error("Regular polygon: nb must be >= 3")
		return
	end -- za = center zb a vertex
	local type = "regular_polygon"
	local vertices = regular_(za, zb, nb)
	local center = za
	local through = zb
	local angle = tkz.tau / nb
	local circumradius = point.abs(zb - za)
	local circle = circle:new(za, zb)
	local inradius = circumradius * math.cos(math.pi / nb)
	local side = 2 * circumradius * math.sin(math.pi / nb)
	local apothem_foot = projection_(vertices[1], vertices[2], za)
	local perimeter = nb * side
	local area = (perimeter * inradius) / 2
	local regular = {
		type = type,
		center = center,
		through = through,
		circumradius = circumradius,
		inradius = inradius,
		apothem = inradius,
		vertices = vertices,
		circle = circle,
		nb = nb,
		angle = angle,
		side = side,
		apothem_foot = apothem_foot,
		perimeter = perimeter,
		area = area,
	}
	setmetatable(regular, self)
	return regular
end

setmetatable(regular_polygon, {
	__call = function(cls, ...)
		return cls:new(...)
	end,
})
function regular_polygon:get(i)
	if i == nil then
		return self.vertices -- retourne toute la matrice
	else
		if i <= self.nb then
			return self.vertices[i]
		else
			tex.error("Bad argument")
		end
	end
end

function regular_polygon:incircle()
	return circle:new(self.center, projection_(self.vertices[1], self.vertices[2], self.center))
end

function regular_polygon:name(nm)
	for k, v in ipairs(self.vertices) do
		z[nm .. k] = v
	end
end

return regular_polygon
