function [romnum] = roman(num)
% ------------------------------------------------
% [romnum] = int2roman(num)
% Function converts a integer 2 a roman number (string)
% ------------------------------------------------
% output:
% num        ...roman number to be converted (number or string)
%

% author: Alexander Michel
% date: 2010/08/09
%
% Copyright 2010 Thomas Knig, Alexander Michel
%
% This file is part of NumericPlots.
%
% NumericPlots is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% any later version.
% 
% NumericPlots is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with NumericPlots.  If not, see <http://www.gnu.org/licenses/>.

if(isstr(num))
    numint = str2num(num);
else
    numint = num;
end
numint = round(numint);

rest = numint;
div = [1000 900 500 400 100 90 50 40 10 9 5 4 1];
letters = {'M','CM','D', 'CD','C','XC','L','XL','X','IX','V','IV','I'};
ii = 1;
while(rest~=0)
    z(ii) = floor(rest/div(ii));
    rest = mod(rest,div(ii));
    ii = ii+1;
end
romnum = '';

for(ii=1:length(z));
    for(jj=1:z(ii))
        romnum = [romnum letters{ii}];
    end
end

end



    