#!/bin/csh
# Copyright (C) 1994, Basil K. Malyshev. All rights reserved.
# WARNING this script was created automatically.
set lib=/usr/local/lib/fload
setenv FONTPATH /usr/local/lib/texmf/fonts:/usr/local/lib/ISOFonts/pfa
#!
#! File: UpdateMap.csh
#!       This C shell script updates font map which is used by FLoad script.
#!
#! Copyright (C) 1994, Basil K. Malyshev. All rights reserved.
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

setenv SUBFONT "`which subfont`"
if ( ! -e "$SUBFONT" ) then
  echo Can not found SubFont program in path $path
  exit
endif

#### Scan all font directories and add records to Fontmap.t1
# Split FPATH variable into elements 
set pathSave=($path)
setenv PATH $FONTPATH
set fpath=($path)
set path=($pathSave)
# Now go throght all font directories
echo >$lib/Fontmap.t1
foreach root ($fpath)
   echo "Scanning $root directory..."
   echo "%% This part was constructed from $root directory" >>$lib/Fontmap.t1
   pushd root
   find . -name "*.pf[ab]" -exec $SUBFONT -z$lib/Fontmap.t1 {} \;
   popd
end
###

