#!/usr/bin/perl

package eBay::API::XML::Call::SetUserNotes::SetUserNotesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetUserNotesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetUserNotes::SetUserNotesRequestType

=head1 DESCRIPTION

Enables users to add, replace, and delete My eBay notes for
items that are being tracked in the My eBay All Selling and
All Buying areas.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetUserNotes::SetUserNotesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::SetUserNotesActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:SetUserNotesActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::SetUserNotesActionCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'NoteText', 'xs:string', '', '', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

Specifies whether to add/update the note or delete.

  RequiredInput: Yes
#    Argument: 'ns:SetUserNotesActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:SetUserNotesActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setItemID()

ID of the item to which the My eBay note will be
attached. Notes can only be added to items that are
currently being tracked in My eBay.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setNoteText()

Text of the note. Maximum 250 characters. Required only
if the Action is AddOrUpdate. This note text will
completely replace any existing My eBay note for the
specified item.

MaxLength: 250

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setNoteText {
  my $self = shift;
  $self->{'NoteText'} = shift
}

=head2 getNoteText()

#    Returns: 'xs:string'

=cut

sub getNoteText {
  my $self = shift;
  return $self->{'NoteText'};
}


=head2 setTransactionID()

ID of the transaction to which the My eBay note will be
attached. Notes can only be added to transactions that are
currently being tracked in My eBay.
You can see it in the Won list of GetMyeBayBuying if you are the buyer.
You can see it from Sold list of GetMyeBaySelling if you are the seller.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
