/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomCharacterData;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.Node;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=DomCharacterData.class)
public class CharacterDataImpl
extends Node {
    @JsxGetter
    public Object getData() {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        return domCharacterData.getData();
    }

    @JsxSetter
    public void setData(String newValue) {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        domCharacterData.setData(newValue);
    }

    @JsxGetter
    public int getLength() {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        return domCharacterData.getLength();
    }

    @JsxFunction
    public void appendData(String arg) {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        domCharacterData.appendData(arg);
    }

    @JsxFunction
    public void deleteData(int offset, int count) {
        DomCharacterData domCharacterData;
        if (offset < 0) {
            throw Context.reportRuntimeError((String)("Provided offset: " + offset + " is less than zero."));
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOM_CDATA_DELETE_THROWS_NEGATIVE_COUNT)) {
            if (count < 0) {
                throw Context.reportRuntimeError((String)("Provided count: " + count + " is less than zero."));
            }
            if (count == 0) {
                return;
            }
        }
        if (offset > (domCharacterData = (DomCharacterData)this.getDomNodeOrDie()).getLength()) {
            throw Context.reportRuntimeError((String)("Provided offset: " + offset + " is greater than length."));
        }
        domCharacterData.deleteData(offset, count);
    }

    @JsxFunction
    public void insertData(int offset, String arg) {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        domCharacterData.insertData(offset, arg);
    }

    @JsxFunction
    public void replaceData(int offset, int count, String arg) {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        domCharacterData.replaceData(offset, count, arg);
    }

    @JsxFunction
    public String substringData(int offset, int count) {
        DomCharacterData domCharacterData = (DomCharacterData)this.getDomNodeOrDie();
        return domCharacterData.substringData(offset, count);
    }
}

