/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImmutable;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;

public class Sinusoidal
extends ProjectionImpl {
    private final double earthRadius;
    private double centMeridian;
    private double falseEasting;
    private double falseNorthing;

    @Override
    public ProjectionImpl constructCopy() {
        Sinusoidal result = new Sinusoidal(this.getCentMeridian(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public Sinusoidal() {
        this(0.0, 0.0, 0.0, EARTH_RADIUS);
    }

    public Sinusoidal(double centMeridian, double false_easting, double false_northing, double radius) {
        super("sinusoidal", false);
        this.centMeridian = centMeridian;
        this.falseEasting = false_easting;
        this.falseNorthing = false_northing;
        this.earthRadius = radius;
        this.addParameter("grid_mapping_name", "sinusoidal");
        this.addParameter("longitude_of_central_meridian", centMeridian);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (false_easting != 0.0 || false_northing != 0.0) {
            this.addParameter("false_easting", false_easting);
            this.addParameter("false_northing", false_northing);
            this.addParameter("units", "km");
        }
    }

    public double getCentMeridian() {
        return this.centMeridian;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public void setCentMeridian(double centMeridian) {
        this.centMeridian = centMeridian;
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sinusoidal that = (Sinusoidal)o;
        if (Double.compare(that.centMeridian, this.centMeridian) != 0) {
            return false;
        }
        if (Double.compare(that.earthRadius, this.earthRadius) != 0) {
            return false;
        }
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        return Double.compare(that.falseNorthing, this.falseNorthing) == 0;
    }

    public int hashCode() {
        long temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.centMeridian != 0.0 ? Double.doubleToLongBits(this.centMeridian) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sinusoidal");
        sb.append("{earthRadius=").append(this.earthRadius);
        sb.append(", centMeridian=").append(this.centMeridian);
        sb.append(", falseEasting=").append(this.falseEasting);
        sb.append(", falseNorthing=").append(this.falseNorthing);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        double x2;
        if (ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2)) {
            return true;
        }
        double x1 = pt1.getX() - this.falseEasting;
        return x1 * (x2 = pt2.getX() - this.falseEasting) < 0.0 && Math.abs(x1 - x2) > this.earthRadius;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double deltaLon_d = LatLonPointImpl.range180(latLon.getLongitude() - this.centMeridian);
        double fromLat_r = Math.toRadians(latLon.getLatitude());
        double toX = this.earthRadius * Math.toRadians(deltaLon_d) * Math.cos(fromLat_r);
        double toY = this.earthRadius * fromLat_r;
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLon_r;
        double fromX = world.getX() - this.falseEasting;
        double fromY = world.getY() - this.falseNorthing;
        double toLat_r = fromY / this.earthRadius;
        if (Misc.closeEnough(Math.abs(toLat_r), 1.5707963267948966, 1.0E-10)) {
            toLat_r = toLat_r < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
            toLon_r = Math.toRadians(this.centMeridian);
        } else if (Math.abs(toLat_r) < 1.5707963267948966) {
            toLon_r = Math.toRadians(this.centMeridian) + fromX / (this.earthRadius * Math.cos(toLat_r));
        } else {
            return LatLonPointImmutable.INVALID;
        }
        if (Misc.closeEnough(Math.abs(toLon_r), Math.PI, 1.0E-10)) {
            toLon_r = toLon_r < 0.0 ? -Math.PI : Math.PI;
        } else if (Math.abs(toLon_r) > Math.PI) {
            return LatLonPointImmutable.INVALID;
        }
        result.setLatitude(Math.toDegrees(toLat_r));
        result.setLongitude(Math.toDegrees(toLon_r));
        return result;
    }

    @Override
    public LatLonRect projToLatLonBB(ProjectionRect projBB) {
        ProjectionPoint southPole;
        LinkedList<ProjectionPoint> pointsOfInterest = new LinkedList<ProjectionPoint>();
        ProjectionPoint northPole = this.latLonToProj(new LatLonPointImpl(90.0, 0.0));
        if (projBB.contains(northPole)) {
            pointsOfInterest.add(northPole);
        }
        if (projBB.contains(southPole = this.latLonToProj(new LatLonPointImpl(-90.0, 0.0)))) {
            pointsOfInterest.add(southPole);
        }
        if (pointsOfInterest.size() == 2) {
            return new LatLonRect(new LatLonPointImpl(-90.0, -180.0), new LatLonPointImpl(90.0, 180.0));
        }
        List<ProjectionPoint> corners = Arrays.asList(projBB.getLowerLeftPoint(), projBB.getLowerRightPoint(), projBB.getUpperLeftPoint(), projBB.getUpperRightPoint());
        for (ProjectionPoint corner : corners) {
            if (this.projToLatLon(corner) == LatLonPointImmutable.INVALID) continue;
            pointsOfInterest.add(corner);
        }
        pointsOfInterest.addAll(this.getMapEdgeIntercepts(projBB));
        return this.makeLatLonRect(pointsOfInterest);
    }

    public List<ProjectionPoint> getMapEdgeIntercepts(ProjectionRect projBB) {
        LinkedList<ProjectionPoint> intercepts = new LinkedList<ProjectionPoint>();
        for (ProjectionPoint topIntercept : this.getMapEdgeInterceptsAtY(projBB.getUpperRightPoint().getY())) {
            if (!this.pointIsBetween(topIntercept, projBB.getUpperLeftPoint(), projBB.getUpperRightPoint())) continue;
            intercepts.add(topIntercept);
        }
        for (ProjectionPoint rightIntercept : this.getMapEdgeInterceptsAtX(projBB.getUpperRightPoint().getX())) {
            if (!this.pointIsBetween(rightIntercept, projBB.getUpperRightPoint(), projBB.getLowerRightPoint())) continue;
            intercepts.add(rightIntercept);
        }
        for (ProjectionPoint bottomIntercept : this.getMapEdgeInterceptsAtY(projBB.getLowerLeftPoint().getY())) {
            if (!this.pointIsBetween(bottomIntercept, projBB.getLowerLeftPoint(), projBB.getLowerRightPoint())) continue;
            intercepts.add(bottomIntercept);
        }
        for (ProjectionPoint leftIntercept : this.getMapEdgeInterceptsAtX(projBB.getLowerLeftPoint().getX())) {
            if (!this.pointIsBetween(leftIntercept, projBB.getLowerLeftPoint(), projBB.getUpperLeftPoint())) continue;
            intercepts.add(leftIntercept);
        }
        return intercepts;
    }

    public List<ProjectionPoint> getMapEdgeInterceptsAtX(double x0) {
        LinkedList<ProjectionPoint> mapEdgeIntercepts = new LinkedList<ProjectionPoint>();
        if (this.projToLatLon(x0, this.falseNorthing) == LatLonPointImmutable.INVALID) {
            return mapEdgeIntercepts;
        }
        double x0natural = x0 - this.falseEasting;
        double limitLon_r = x0natural < 0.0 ? -Math.PI : Math.PI;
        double deltaLon_r = limitLon_r - Math.toRadians(this.centMeridian);
        double minY = -this.earthRadius * Math.acos(x0natural / (this.earthRadius * deltaLon_r));
        double maxY = this.earthRadius * Math.acos(x0natural / (this.earthRadius * deltaLon_r));
        mapEdgeIntercepts.add(new ProjectionPointImpl(x0, minY + this.falseNorthing));
        mapEdgeIntercepts.add(new ProjectionPointImpl(x0, maxY + this.falseNorthing));
        return mapEdgeIntercepts;
    }

    public List<ProjectionPoint> getMapEdgeInterceptsAtY(double y0) {
        LinkedList<ProjectionPoint> mapEdgeIntercepts = new LinkedList<ProjectionPoint>();
        if (this.projToLatLon(this.falseEasting, y0) == LatLonPointImmutable.INVALID) {
            return mapEdgeIntercepts;
        }
        double minX = this.getXAt(y0, -Math.PI);
        double maxX = this.getXAt(y0, Math.PI);
        mapEdgeIntercepts.add(new ProjectionPointImpl(minX, y0));
        mapEdgeIntercepts.add(new ProjectionPointImpl(maxX, y0));
        return mapEdgeIntercepts;
    }

    private double getXAt(double y0, double lon_r) {
        double y0natural = y0 - this.falseNorthing;
        double deltaLon_r = lon_r - Math.toRadians(this.centMeridian);
        double x = this.earthRadius * deltaLon_r * Math.cos(y0natural / this.earthRadius);
        return x + this.falseEasting;
    }

    private boolean pointIsBetween(ProjectionPoint point, ProjectionPoint linePoint1, ProjectionPoint linePoint2) {
        if (linePoint1.getX() == linePoint2.getX()) {
            assert (point.getX() == linePoint1.getX()) : "point should have the same X as the line.";
            double minY = Math.min(linePoint1.getY(), linePoint2.getY());
            double maxY = Math.max(linePoint1.getY(), linePoint2.getY());
            return DoubleMath.fuzzyCompare(minY, point.getY(), 1.0E-6) <= 0 && DoubleMath.fuzzyCompare(point.getY(), maxY, 1.0E-6) <= 0;
        }
        if (linePoint1.getY() == linePoint2.getY()) {
            assert (point.getY() == linePoint1.getY()) : "point should have the same Y as the line.";
            double minX = Math.min(linePoint1.getX(), linePoint2.getX());
            double maxX = Math.max(linePoint1.getX(), linePoint2.getX());
            return DoubleMath.fuzzyCompare(minX, point.getX(), 1.0E-6) <= 0 && DoubleMath.fuzzyCompare(point.getX(), maxX, 1.0E-6) <= 0;
        }
        throw new AssertionError((Object)"CAN'T HAPPEN: linePoint1 and linePoint2 are corners on the same side of a bounding box; they must have *identical* x or y values.");
    }

    private LatLonRect makeLatLonRect(List<ProjectionPoint> projPoints) {
        if (projPoints.isEmpty()) {
            return LatLonRect.INVALID;
        }
        double minLat = Double.MAX_VALUE;
        double minLon = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double maxLon = -1.7976931348623157E308;
        for (ProjectionPoint projPoint : projPoints) {
            LatLonPoint latLonPoint = this.projToLatLon(projPoint);
            assert (latLonPoint != LatLonPointImmutable.INVALID) : "We should have filtered out bad points and added good ones. WTF?";
            minLat = Math.min(minLat, latLonPoint.getLatitude());
            minLon = Math.min(minLon, latLonPoint.getLongitude());
            maxLat = Math.max(maxLat, latLonPoint.getLatitude());
            maxLon = Math.max(maxLon, latLonPoint.getLongitude());
        }
        return new LatLonRect(new LatLonPointImpl(minLat, minLon), new LatLonPointImpl(maxLat, maxLon));
    }
}

