/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.sql.SQLTransientException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.sis.internal.referencing.EPSGFactoryProxy;
import org.apache.sis.internal.referencing.LazySet;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.MultiAuthoritiesFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.referencing.factory.sql.EPSGFactory;
import org.apache.sis.util.logging.Logging;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.FactoryException;

final class AuthorityFactories<T extends AuthorityFactory>
extends LazySet<T> {
    private static final GeodeticAuthorityFactory[] EPSG = new GeodeticAuthorityFactory[1];
    static final MultiAuthoritiesFactory ALL = new MultiAuthoritiesFactory(new AuthorityFactories<CRSAuthorityFactory>(CRSAuthorityFactory.class), new AuthorityFactories<CSAuthorityFactory>(CSAuthorityFactory.class), new AuthorityFactories<DatumAuthorityFactory>(DatumAuthorityFactory.class), new AuthorityFactories<CoordinateOperationAuthorityFactory>(CoordinateOperationAuthorityFactory.class)){
        {
            this.setLenient(true);
        }

        @Override
        public void reload() {
            AuthorityFactories.EPSG(null);
            super.reload();
        }
    };

    private AuthorityFactories(Class<T> clazz) {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void EPSG(GeodeticAuthorityFactory geodeticAuthorityFactory) {
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            AuthorityFactories.EPSG[0] = geodeticAuthorityFactory;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GeodeticAuthorityFactory EPSG() {
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            GeodeticAuthorityFactory geodeticAuthorityFactory = EPSG[0];
            if (geodeticAuthorityFactory == null) {
                try {
                    geodeticAuthorityFactory = new EPSGFactory(null);
                }
                catch (FactoryException factoryException) {
                    AuthorityFactories.log(factoryException, false);
                    geodeticAuthorityFactory = EPSGFactoryFallback.INSTANCE;
                }
                AuthorityFactories.EPSG[0] = geodeticAuthorityFactory;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return geodeticAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GeodeticAuthorityFactory fallback(UnavailableFactoryException unavailableFactoryException) throws UnavailableFactoryException {
        boolean bl = unavailableFactoryException.getCause() instanceof SQLTransientException;
        AuthorityFactory authorityFactory = unavailableFactoryException.getUnavailableFactory();
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            boolean bl2;
            GeodeticAuthorityFactory geodeticAuthorityFactory = EPSG[0];
            boolean bl3 = bl2 = geodeticAuthorityFactory == EPSGFactoryFallback.INSTANCE;
            if (!bl2) {
                if (authorityFactory != geodeticAuthorityFactory) {
                    throw unavailableFactoryException;
                }
                geodeticAuthorityFactory = EPSGFactoryFallback.INSTANCE;
                if (!bl) {
                    ALL.reload();
                    AuthorityFactories.EPSG[0] = geodeticAuthorityFactory;
                }
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (!bl2) {
                AuthorityFactories.log(unavailableFactoryException, true);
            }
            return geodeticAuthorityFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean failure(UnavailableFactoryException unavailableFactoryException) {
        if (unavailableFactoryException.getCause() instanceof SQLTransientException) return true;
        AuthorityFactory authorityFactory = unavailableFactoryException.getUnavailableFactory();
        GeodeticAuthorityFactory[] geodeticAuthorityFactoryArray = EPSG;
        synchronized (EPSG) {
            GeodeticAuthorityFactory geodeticAuthorityFactory = EPSG[0];
            if (geodeticAuthorityFactory == EPSGFactoryFallback.INSTANCE) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            if (authorityFactory != geodeticAuthorityFactory) return true;
            ALL.reload();
            AuthorityFactories.EPSG[0] = EPSGFactoryFallback.INSTANCE;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    private static void log(Exception exception, boolean bl) {
        String string = exception.getMessage();
        if (string == null) {
            string = exception.toString();
        }
        LogRecord logRecord = new LogRecord(bl ? Level.WARNING : Level.CONFIG, string);
        if (bl && !(exception instanceof UnavailableFactoryException)) {
            logRecord.setThrown(exception);
        }
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(CRS.class, "getAuthorityFactory", logRecord);
    }

    @Override
    protected T[] initialValues() {
        AuthorityFactories.EPSG();
        return EPSG;
    }

    @Override
    protected T next(Iterator<? extends T> iterator) {
        AuthorityFactory authorityFactory = (AuthorityFactory)iterator.next();
        if (authorityFactory instanceof EPSGFactoryProxy) {
            authorityFactory = iterator.hasNext() ? (AuthorityFactory)iterator.next() : null;
        }
        return (T)authorityFactory;
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.referencing"){

            @Override
            protected void classpathChanged() {
                ALL.reload();
            }
        });
    }
}

