/**
 * pdfXtk-Extras - PDF Extraction Toolkit Extras
 * Copyright (c) by the authors/contributors.  All rights reserved.
 * This project includes code from PDFBox and TouchGraph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the names pdfXtk or PDF Extraction Toolkit; nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://pdfxtk.sourceforge.net
 *
 */
package at.ac.tuwien.dbai.pdfwrap.comparators;

import java.util.Comparator;

import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;

/**
 * @author Tamir Hassan, hassan@dbai.tuwien.ac.at
 * @version GraphWrap Beta 1
 */
public class XYTextComparatorOCR implements Comparator
{
	public int compare(Object o1, Object o2)
	{
		// changed from GenericSegment in order to allow
		// a tolerance on font size 7.08.08
		TextSegment obj1 = (TextSegment) o1, obj2 = (TextSegment) o2;
		// double x1 = obj1.getX(), y1 = obj1.getY();
		// double x2 = obj2.getX(), y2 = obj2.getY();
		float x1 = obj1.getX1(), y1 = obj1.getY1();
		float x2 = obj2.getX1(), y2 = obj2.getY1();
		//if (y1 == y2)
		// modified 8.11.06
//		float tolerance = (float)(obj1.getSegFontSize() + obj2.getSegFontSize()) * Utils.sameLineTolerance; // 10% of avg
//		if (Utils.within(y1, y2, tolerance))
		if (SegmentUtils.vertIntersect(obj1, obj2))
		{
			return (int) (x1 - x2);
		} 
		else
		{
			return (int) (y2 - y1);
			// return (int) (y1 - y2);
		}
	}

	public boolean equals(Object obj)
	{
		return obj.equals(this);
	}
}